/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.cert.TbsCertHolder;
import com.xdja.pki.itsca.oer.cert.bean.CertHashType;
import com.xdja.pki.itsca.oer.cert.bean.GeographicRegionType;
import com.xdja.pki.itsca.oer.cert.bean.IssueIdType;
import com.xdja.pki.itsca.oer.cert.bean.OERCertificate;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class CertificateHolder {
    public static OERCertificate build(byte[] data) throws Exception {
        byte[] goal;
        byte[] bytes;
        Certificate certificate = Certificate.getInstance(data);
        OERCertificate oerCertificate = new OERCertificate();
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        if (BigIntegers.fromUnsignedByteArray((byte[])encode, (int)0, (int)1).intValue() == 128) {
            bytes = GMSSLSM3DigestUtils.digestByBC((byte[])certificate.getEncode());
            goal = new byte[8];
            System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
            signerHashId8 = ByteArrayUtils.hexEncode(goal);
            oerCertificate.setIssueIdType(IssueIdType.NULL);
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = ByteArrayUtils.hexEncode(hashedId8.getString());
            oerCertificate.setIssueIdType(IssueIdType.CERTIFICATE_DIGEST);
            byte[] hashAlg = certificate.getIssuerId().getCertificateDigest().getHashAlgorithm().getEncode();
            BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])hashAlg, (int)0, (int)1);
            if (choice.intValue() == 0) {
                oerCertificate.setIssueIdAlg(CertHashType.SGD_SM3);
                new HashAlgorithm(HashAlgorithm.SGD_SM3);
            } else if (choice.intValue() == 1) {
                oerCertificate.setIssueIdAlg(CertHashType.SHA_256);
            } else {
                throw new Exception("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
            }
        }
        bytes = GMSSLSM3DigestUtils.digestByBC((byte[])certificate.getEncode());
        goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        String selfHashId8 = ByteArrayUtils.hexEncode(goal);
        byte[] r = certificate.getSignature().getR().getxOnly().getString();
        byte[] s = certificate.getSignature().getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        oerCertificate.setSelfHashId10(Hex.toHexString((byte[])ByteArrayUtils.getHashId10(data)));
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignerHashId8(signerHashId8);
        oerCertificate.setSelfHashId8(selfHashId8);
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setSignature(signature);
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionType.CIRCULAR_REGION.id) {
            oerCertificate.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.RECTANGULAR_REGION.id) {
            oerCertificate.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.POLYGONAL_REGION.id) {
            oerCertificate.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        oerCertificate.setRegionType(tbsCert.getRegionType());
        return oerCertificate;
    }
}

