/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.InnerATRequest;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.security.PrivateKey;

public class PseudonymCertRequestSignBuilder {
    public static SecuredMessage build(PrivateKey privateKey, InnerATRequest innerATRequest) throws Exception {
        SignedData signedData = new SignedData();
        signedData.setSignerInfo(new SignerInfo(new Null()));
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(new Int(40965L));
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime()));
        headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
        TBSData tbsData = new TBSData();
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(innerATRequest.getEncode());
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsData.getEncode());
        byte[] nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
        byte[] data = ByteArrayUtils.buildUpByte(tbsHash, nullHash);
        Signature signature = SignatureBuild.build(privateKey, data);
        signedData.setTbs(tbsData);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        SecuredMessage securedMessage = new SecuredMessage();
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

