package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.Certificate;

import java.security.PrivateKey;

/***
 *NormalCertRequestSign ::= SecureMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				SequenceOfCertificate(SIZE(1))
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid(40963),
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey  ABSENT
 *                }),
 * 				data( CONTAINING NormalCertRequestEnc ),
 * 				extHash  ABSENT
 *            })* 		})
 *    })
 * })
 */
public class NormalCertRequestSignBuilder extends SecuredMessageBuild {
    /**
     * @param privateKey  私钥签名使用
     * @param reqData    安全信息内部包的安全信息
     * @param certificate 签名者证书
     * @return EnrollmentCertRequest   F.2.1　注册证书请求数据格式
     */
    public SecuredMessage build(PrivateKey privateKey, SecuredMessage reqData, Certificate certificate) throws Exception {
        return super.build(privateKey, reqData, 40963, certificate);
    }
}
