package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;

/***
 * NormalCertResp ::= SecureMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				SequenceOfCertificate(SIZE(1))
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid(40964),
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey  ABSENT
 *                }),
 * 				data( CONTAINING NormalCertRespData ),
 * 				extHash  ABSENT
 *            })* 		})
 *    })
 * })
 * NormalCertResp的签名数据NormalCertRespData构成如下：
 * NormalCertRespData ::= SecureMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		encData(WITH COMPONENTS { ...,
 * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 * 				RecipientInfo(WITH COMPONENTS {
 * 					signedDataRecipInfo
 *                })* 			}        ))
 *    })
 *    })
 * })
 */
public class NormalCertRespData extends CertDataBuilder {
    /**
     * @param certRequest 证书请求
     * @param key         对称密钥 16位
     * @param data        加密数据
     * @return NormalCertRespData   F.3.2　非注册证书应答数据格式
     */
    public SecuredMessage build(CertRequest certRequest, byte[] key, byte[] data) throws Exception {
        return super.buildSecuredMessage(certRequest, true, key, data);
    }

    public SecuredMessage build(Certificate pcaCert, EccPoint publicKey, byte[] key, byte[] data) throws Exception {
        return super.buildSecuredMessage(pcaCert, publicKey, true, key, data);
    }
}
