package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * -- 6.2.9 加密的对称秘钥
 * -- 说明 eccCurve 为非对称密码运算使用的椭圆曲线
 * --      向量v：发送方用于加密的临时密钥，此临时密钥v只使用一次，每次加密应生成新的密钥
 * --      向量c：包含被加密的对称密钥
 * --      向量t：当公钥加密算法为国密算法时，对应过密算法中的M，当公钥加密算法为国际算法时，包含16字节的身份验证标记，且放在前16字节，后16字节为0
 * EciesEncryptedKey ::= SEQUENCE {
 * eccCurve EccCurve,
 * v        ECCPoint,
 * c        OCTET STRING(SIZE (16))
 * t        OCTET STRING(SIZE (32))
 * };
 */
public class EciesEncryptedKey extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(EciesEncryptedKey.class);
    private EccCurve eccCurve;
    private EccPoint v;
    private OctetString c;
    private OctetString t;

    public EciesEncryptedKey() {
        super(false, false);
    }

    public static EciesEncryptedKey getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey start data ", data);
        EciesEncryptedKey kek = new EciesEncryptedKey();
        //    BigInteger eccCurve = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        EccCurve eccCurve = EccCurve.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey EccCurve data ", eccCurve.getEncode());
        data = eccCurve.getGoal();
        kek.setEccCurve(eccCurve);
//        if (eccCurve.intValue() == 0) {
//            kek.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
//        } else if (eccCurve.intValue() == 1) {
//            kek.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
//        } else if (eccCurve.intValue() == 2) {
//            kek.setEccCurve(new EccCurve(EccCurve.BRAINPOOL_P_256_R1));
//        } else {
//            throw new Exception("不支持的类型");
//        }
//        byte[] goal = new byte[data.length - 1];
//        System.arraycopy(data, 1, goal, 0, goal.length);
//        data = goal;
        EccPoint v = EccPoint.getInstance(data);
        kek.setV(v);
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey v data", v.getEncode());
        data = v.getGoal();
        OctetString c = new OctetString();
        byte[] goal = new byte[16];
        System.arraycopy(data, 0, goal, 0, goal.length);
        c.setLength(16);
        c.setString(goal);
        kek.setC(c);
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey c data ", c.getEncode());
        OctetString t = new OctetString();
        goal = new byte[32];
        System.arraycopy(data, 16, goal, 0, goal.length);
        t.setLength(32);
        t.setString(goal);
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey t data ", t.getEncode());
        kek.setT(t);
        goal = new byte[data.length - 32 - 16];
        System.arraycopy(data, 32 + 16, goal, 0, goal.length);
        kek.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "EciesEncryptedKey lave data ", kek.getGoal());
        return kek;
    }

    public EccCurve getEccCurve() {
        return eccCurve;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public EccPoint getV() {
        return v;
    }

    public void setV(EccPoint v) {
        this.v = v;
    }

    public OctetString getC() {
        return c;
    }

    public void setC(OctetString c) {
        this.c = c;
    }

    public OctetString getT() {
        return t;
    }

    public void setT(OctetString t) {
        this.t = t;
    }

    public void setC(byte[] c) {
        this.c = new OctetString();
        this.c.setLength(16);
        this.c.setString(c);


    }

    public void setT(byte[] t) {
        this.t = new OctetString();
        this.t.setLength(32);
        this.t.setString(t);

    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(eccCurve);
        vector.add(v);
        vector.add(c);
        vector.add(t);
        return vector;
    }
}
