package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/**
 * -- 说明 PreSharedKeyRecipientInfo 预共享的对称密钥；
 * --      hashAlg 计算smyKeyHash 的摘要算法
 * PreSharedKeyRecipientInfo ::= SEQUENCE{
 * hashAlg     HashAlgorithm,
 * smyKeyHash  HashedId8,
 * };
 */
public class PreSharedKeyRecipientInfo extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PreSharedKeyRecipientInfo.class);
    private HashAlgorithm hashAlg;
    private HashedId8 smyKeyHash;

    public HashAlgorithm getHashAlg() {
        return hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public HashedId8 getSmyKeyHash() {
        return smyKeyHash;
    }

    public void setSmyKeyHash(HashedId8 smyKeyHash) {
        this.smyKeyHash = smyKeyHash;
    }

    public PreSharedKeyRecipientInfo() {
        super(false, false);
    }

    public static PreSharedKeyRecipientInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "PreSharedKeyRecipientInfo start data ", data);
        PreSharedKeyRecipientInfo preSharedKeyRecipientInfo = new PreSharedKeyRecipientInfo();
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "PreSharedKeyRecipientInfo hashAlgorithm data ", hashAlgorithm.getEncode());
        preSharedKeyRecipientInfo.setHashAlg(hashAlgorithm);
        data = hashAlgorithm.getGoal();
        byte[] goal = new byte[8];
        System.arraycopy(data, 0, goal, 0, goal.length);
        HashedId8 hashedId8 = new HashedId8(goal);
        goal = new byte[data.length - 8];
        ByteArrayUtils.printHexBinary(logger, "PreSharedKeyRecipientInfo HashedId8 data ", hashedId8.getEncode());
        preSharedKeyRecipientInfo.setSmyKeyHash(hashedId8);
        preSharedKeyRecipientInfo.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "PreSharedKeyRecipientInfo lave data ", preSharedKeyRecipientInfo.getGoal());
        return preSharedKeyRecipientInfo;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(hashAlg);
        vector.add(smyKeyHash);
        return vector;
    }
}
