package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/***
 * -- 6.2.1.7 签名公钥 国际没有
 *
 *  ::= SEQUENCE {
 *     curve EccCurve,
 *     key   ECCPoint,
 *     ...
 * }
 */
public class PublicVerifyKey extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PublicVerifyKey.class);
    private EccCurve eccCurve;
    private EccPoint eccPoint;

    public PublicVerifyKey() {
        super(true, false);
    }

    public static PublicVerifyKey getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey start data", data);
        BigInteger extension = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey publicVerifyKey = new PublicVerifyKey();
        EccCurve eccCurve = EccCurve.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey eccCurve data", eccCurve.getEncode());
        data = eccCurve.getGoal();
        EccPoint eccPoint = EccPoint.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey eccPoint data", eccPoint.getEncode());
        publicVerifyKey.setEccCurve(eccCurve);
        publicVerifyKey.setEccPoint(eccPoint);
        publicVerifyKey.setGoal(eccPoint.getGoal());
        //可扩展 不写
        if (extension.intValue() == 0x80) {

        }
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey lave data", publicVerifyKey.getGoal());
        return publicVerifyKey;
    }

    public EccCurve getEccCurve() {
        return eccCurve;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public EccPoint getEccPoint() {
        return eccPoint;
    }

    public void setEccPoint(EccPoint eccPoint) {
        this.eccPoint = eccPoint;
    }

//    public PublicVerifyKey(byte[] x, byte[] y) throws IOException {
//        super(true);
//
//        EccCurve eccCurve = new EccCurve(EccCurve.SGD_SM2);
//        this.write(eccCurve.getEncode());
//
//        EccPoint eccPoint = new EccPoint();
//        Sequence uncompressed = new Sequence(false);
//        OctetString xos = new OctetString(x, 32);
//        uncompressed.write(xos.getEncode());
//        OctetString yos = new OctetString(y, 32);
//        uncompressed.write(yos.getEncode());
//        eccPoint.setUncompressed(uncompressed);
//        this.write(eccPoint.getEncode());
//    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(eccCurve);
        vector.add(eccPoint);
        return vector;
    }
}
