package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.app.bean.SM4CipherType;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.swing.plaf.metal.OceanTheme;
import java.util.Vector;

/**
 * -- iv:初始化向量
 * -- cipher:  密文
 * SM4CipherText ::= SEQUENCE{
 * iv  OCTET STRING(SIZE(16)),
 * cipher  CipherText
 * };
 */
public class SM4CipherText extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SM4CipherText.class);
    private OctetString iv;
    private CipherText cipher;

    public SM4CipherText() {
        super(false, false);
    }

    public static SM4CipherText getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SM4CipherText start data", data);
        OctetString octetString = OctetString.getInstance(data);
        OctetString iv = new OctetString();
        iv.setLength(16);
        iv.setString(octetString.getString());
        ByteArrayUtils.printHexBinary(logger, "SM4CipherText iv data", iv.getEncode());
        data = octetString.getGoal();
        octetString = OctetString.getInstance(data);
        CipherText cipher = new CipherText();
        cipher.setString(octetString.getString());
        ByteArrayUtils.printHexBinary(logger, "SM4CipherText cipher data", cipher.getEncode());
        data = octetString.getGoal();
        SM4CipherText sm4CipherText = new SM4CipherText();
        sm4CipherText.setIv(iv);
        sm4CipherText.setCipher(cipher);
        sm4CipherText.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "SM4CipherText lave data", sm4CipherText.getGoal());
        return sm4CipherText;
    }

    public void setIv(OctetString iv) {
        this.iv = iv;
    }

    public void setIv(byte[] iv) {
        this.iv = new OctetString();
        this.iv.setLength(16);
        this.iv.setString(iv);
    }

    public void setCipher(CipherText cipher) {
        this.cipher = cipher;
    }

    public OctetString getIv() {
        return iv;
    }

    public CipherText getCipher() {
        return cipher;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(iv);
        vector.add(cipher);
        return vector;
    }
}
