package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.SequenceOf;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class SequenceOfRecipientInfo extends SequenceOf {
    private static Logger logger = LoggerFactory.getLogger(SequenceOfRecipientInfo.class);

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        super.addOERObject(recipientInfo);
    }

    private List<RecipientInfo> recipientInfos = new ArrayList<>();

    public List<RecipientInfo> getRecipientInfos() {
        return recipientInfos;
    }

    public void setRecipientInfos(RecipientInfo recipientInfo) {
        this.recipientInfos.add(recipientInfo);
    }

    public static SequenceOfRecipientInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SequenceOfRecipientInfo data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        for (int i = 0; i < length.intValue(); i++) {
            RecipientInfo instance = RecipientInfo.getInstance(goal);
            goal = instance.getGoal();
            sequenceOfRecipientInfo.setRecipientInfos(instance);
            sequenceOfRecipientInfo.addRecipientInfo(instance);

            ByteArrayUtils.printHexBinary(logger, "SequenceOfRecipientInfo  at index" + i + "RecipientInfo data ", instance.getEncode());
        }
        sequenceOfRecipientInfo.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "SequenceOfRecipientInfo lave data ", goal);
        return sequenceOfRecipientInfo;
    }
}
