package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * SubjectAttribute ::= SEQUENCE {
 *     verificationKey PublicVerifyKey,
 *     encryptionKey PublicEncryptionKey OPTIONAL,
 *     assuranceLevel SubjectAssurance OPTIONAL,
 *     itsAidList SequenceOfItsAidList OPTIONAL,
 *     itsSspList SequenceOfItsAidSspList OPTIONAL,
 *     ...
 * }
 *
 */
public class SubjectAttribute extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SubjectAttribute.class);
    private PublicVerifyKey verifyKey;
    private PublicEncryptionKey encryptionKey;
    private SubjectAssurance assuranceLevel;
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsSspList;

    public SubjectAttribute() {
        super(true, true);
    }

    public static SubjectAttribute getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, " SubjectAttribute start data", data);
        SubjectAttribute subjectAttribute = new SubjectAttribute();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BitByte bitByte = BitByte.setBit(choice.intValue());
        List<Integer> integers = bitByte.readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey publicVerifyKey = PublicVerifyKey.getInstance(data);
        data = publicVerifyKey.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SubjectAttribute publicVerifyKey data", publicVerifyKey.getEncode());
        //可扩展
        if (integers.contains(0)) {
            logger.debug("SubjectAttribute choice Extension");
        }
        //PublicEncryptionKey encryptionKey;
        if (integers.contains(1)) {
            logger.debug("SubjectAttribute choice encryptionKey");
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            subjectAttribute.setEncryptionKey(encryptionKey);
            ByteArrayUtils.printHexBinary(logger, "SubjectAttribute encryptionKey data", encryptionKey.getEncode());
            data = encryptionKey.getGoal();
        }
        //SubjectAssurance assuranceLevel;
        if (integers.contains(2)) {
            logger.debug("SubjectAttribute choice assuranceLevel");
            goal = new byte[1];
            System.arraycopy(data, 0, goal, 0, goal.length);
            SubjectAssurance assuranceLevel = new SubjectAssurance(goal);
            subjectAttribute.setAssuranceLevel(assuranceLevel);
            ByteArrayUtils.printHexBinary(logger, "SubjectAttribute assuranceLevel data", assuranceLevel.getEncode());
            goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
        }
        //SequenceOfItsAidList itsAidList;
        if (integers.contains(3)) {
            logger.debug("SubjectAttribute choice itsAidList");
            SequenceOfItsAidList itsAidList = SequenceOfItsAidList.getInstance(data);
            subjectAttribute.setItsAidList(itsAidList);
            ByteArrayUtils.printHexBinary(logger, "SubjectAttribute itsAidList data", itsAidList.getEncode());
            data = itsAidList.getGoal();
        }
        //SequenceOfItsAidSspList itsSspList;
        if (integers.contains(4)) {
            logger.debug("SubjectAttribute choice itsSspList");
            SequenceOfItsAidSspList itsSspList = SequenceOfItsAidSspList.getInstance(data);
            subjectAttribute.setItsSspList(itsSspList);
            ByteArrayUtils.printHexBinary(logger, "SubjectAttribute itsSspList data", itsSspList.getEncode());
            data = itsSspList.getGoal();
        }
        subjectAttribute.setVerifyKey(publicVerifyKey);
        subjectAttribute.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "SubjectAttribute lave data", data);
        return subjectAttribute;
    }

    public void setVerifyKey(PublicVerifyKey verifyKey) {
        this.verifyKey = verifyKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setAssuranceLevel(SubjectAssurance assuranceLevel) {
        this.assuranceLevel = assuranceLevel;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsSspList(SequenceOfItsAidSspList itsSspList) {
        this.itsSspList = itsSspList;
    }

    public PublicVerifyKey getVerifyKey() {
        return verifyKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return encryptionKey;
    }

    public SubjectAssurance getAssuranceLevel() {
        return assuranceLevel;
    }

    public SequenceOfItsAidList getItsAidList() {
        return itsAidList;
    }

    public SequenceOfItsAidSspList getItsSspList() {
        return itsSspList;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.encryptionKey != null) {
            optionals.add(7);
        }
        if (this.assuranceLevel != null) {
            optionals.add(6);
        }
        if (this.itsAidList != null) {
            optionals.add(5);
        }
        if (this.itsSspList != null) {
            optionals.add(4);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(verifyKey);
        vector.add(encryptionKey);
        vector.add(assuranceLevel);
        vector.add(itsAidList);
        vector.add(itsSspList);
        return vector;
    }
}
