package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Vector;

/***
 * TbsCert ::= SEQUENCE {
 *     subjectInfo             SubjectInfo,
 *     subjectAttribute       SubjectAttribute,
 *     validityRestrictions    ValidityRestriction
 * }
 */
public class TbsCert extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(TbsCert.class);
    private SubjectInfo subjectInfo;
    private SubjectAttribute subjectAttribute;
    private ValidityRestriction validityRestriction;

    public TbsCert() {
        super(false, false);
    }

    public static TbsCert getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "TbsCert start data", data);
        TbsCert tbsCert = new TbsCert();
        SubjectInfo subjectInfo = SubjectInfo.getInstance(data);
        data = subjectInfo.getGoal();
        ByteArrayUtils.printHexBinary(logger, "TbsCert subjectInfo data", subjectInfo.getEncode());
        SubjectAttribute subjectAttribute = SubjectAttribute.getInstance(data);
        data = subjectAttribute.getGoal();
        ByteArrayUtils.printHexBinary(logger, "TbsCert subjectAttribute data", subjectAttribute.getEncode());
        ValidityRestriction validityRestriction = ValidityRestriction.getInstance(data);
        data = validityRestriction.getGoal();
        ByteArrayUtils.printHexBinary(logger, "TbsCert validityRestriction data", validityRestriction.getEncode());
        tbsCert.setSubjectInfo(subjectInfo);
        tbsCert.setSubjectAttribute(subjectAttribute);
        tbsCert.setValidityRestriction(validityRestriction);
        tbsCert.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "TbsCert lave data", tbsCert.getGoal());
        return tbsCert;
    }

    public SubjectInfo getSubjectInfo() {
        return subjectInfo;
    }

    public void setSubjectInfo(SubjectInfo subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public SubjectAttribute getSubjectAttribute() {
        return subjectAttribute;
    }

    public void setSubjectAttribute(SubjectAttribute subjectAttribute) {
        this.subjectAttribute = subjectAttribute;
    }

    public ValidityRestriction getValidityRestriction() {
        return validityRestriction;
    }

    public void setValidityRestriction(ValidityRestriction validityRestriction) {
        this.validityRestriction = validityRestriction;
    }

    //    public TbsCert(PublicKey publicKey, String subjectName) throws IOException {
//        super(false);
//        SubjectType subjectType = new SubjectType(SubjectType.AUTHORIZATION_TICKET);
//        SubjectInfo subjectInfo = new SubjectInfo(subjectType, subjectName.getBytes());
//
//        ECPublicKey ecPublicKey = (ECPublicKey) publicKey;
//        byte[] x = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineX());
//        byte[] y = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineY());
//        PublicVerifyKey verifyKey = new PublicVerifyKey(x, y);
//        SubjectAttribute subjectAttribute = new SubjectAttribute();
//        subjectAttribute.setVerifyKey(verifyKey);
//
//        long timeEnd = TimeUtils.getTimeAfterYear(1);
//        ValidityRestriction validityRestriction = new ValidityRestriction(timeEnd);
//
//        ByteArrayUtils.printHexBinary(logger, "subjectInfo", subjectInfo.getEncode());
//        this.write(subjectInfo.getEncode());
//        ByteArrayUtils.printHexBinary(logger, "subjectAttribute", subjectAttribute.getEncode());
//        this.write(subjectAttribute.getEncode());
//        ByteArrayUtils.printHexBinary(logger, "validityRestriction", validityRestriction.getEncode());
//        this.write(validityRestriction.getEncode());
//    }


    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(subjectInfo);
        vector.add(subjectAttribute);
        vector.add(validityRestriction);

        return vector;
    }
}
