package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * --  6.2.15  三维位置信息
 * --  三维位置信息定义为ThreeDLocation
 * ThreeDLocation ::= SEQUENCE {
 * latitude   Latitude,
 * longitude  Longitude,
 * elevation  Elevation
 * }
 */
public class ThreeDLocation extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ThreeDLocation.class);
    private Latitude latitude;
    private Longitude longitude;
    private Elevation elevation;

    public ThreeDLocation() {
        super(false, false);
    }

    public void setLatitude(Latitude latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Longitude longitude) {
        this.longitude = longitude;
    }

    public void setElevation(Elevation elevation) {
        this.elevation = elevation;
    }

    public Latitude getLatitude() {
        return latitude;
    }

    public Longitude getLongitude() {
        return longitude;
    }

    public Elevation getElevation() {
        return elevation;
    }

    public static ThreeDLocation getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "ThreeDLocation start data", data);
        Int anInt = Latitude.getInstance(data, 4);
        Latitude latitude = new Latitude(anInt.getValue());
        ByteArrayUtils.printHexBinary(logger, "ThreeDLocation Latitude  data", latitude.getEncode());
        data = anInt.getGoal();
        anInt = Longitude.getInstance(data, 4);
        Longitude longitude = new Longitude(anInt.getValue());
        ByteArrayUtils.printHexBinary(logger, "ThreeDLocation Longitude  data", longitude.getEncode());
        data = anInt.getGoal();
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 2);
        Elevation elevation = new Elevation(integer.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        data = goal;
        ByteArrayUtils.printHexBinary(logger, "ThreeDLocation lave data", data);
        ThreeDLocation threeDLocation = new ThreeDLocation();
        threeDLocation.setLatitude(latitude);
        threeDLocation.setElevation(elevation);
        threeDLocation.setLongitude(longitude);
        threeDLocation.setGoal(data);
        return threeDLocation;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(latitude);
        vector.add(longitude);
        vector.add(elevation);
        return vector;
    }
}
