package com.xdja.pki.itsca.oer.asn1.base;

import sun.security.util.BitArray;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;

public class BitByte extends OERObject {

    private boolean[] bitArray = new boolean[]{false, false, false, false, false, false, false, false};

    public BitByte() {
    }

    public BitByte(boolean[] bitArray) {
        this.bitArray = bitArray;
    }

    public static BitByte setBit(int value) throws Exception {
        if (value > 255 || value < 0) {
            throw new Exception("不支持的类型");
        }
        int a; //获取余数
        int ch = 0; //存储二进制
        int i = 0; //存储除了几次
        BitByte bitByte = new BitByte();
        while (value != 0) {
            a = value % 2;
            value = value / 2;
            ch += a * (Math.pow(10, i));
            i++;
        }
        String s = String.valueOf(ch);
        for (i = s.length(); i < 8; i++) {
            s = "0" + s;
        }
        for (i = 0; i < 8; i++) {
            if (s.charAt(i) == '1') {
                bitByte.setIndex(i);
            }
        }
        return bitByte;
    }

    public static BitByte getInstance(byte[] obj) {
        BitByte bitByte = new BitByte();
        bitByte.fromByteArray(obj);
        return bitByte;
    }

    public void setIndex(Integer index) {
        if (index > 7) {
            throw new RuntimeException("index is outside must less than 8");
        }
        this.bitArray[7 - index] = true;
    }

    public List<Integer> readIndexes() throws IOException {
        List<Integer> indexes = new ArrayList<>();
        byte[] bs = this.readBytes(1);
        BitSet bitSet = BitSet.valueOf(bs);
        for (int i = 0; i < bitSet.length(); i++) {
            if (bitSet.get(i)) {
                indexes.add(i);
            }
        }
        return indexes;
    }

    public byte[] toByteArray() {
        return new BitArray(bitArray).toByteArray();
    }

    @Override
    public Vector getValues() {
        Vector vector = new Vector();
        vector.add(toByteArray());
        return vector;
    }
}
