package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.Opaque;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Vector;

// Integer

public class Int extends OERObject {
    private int length = -1;
    private byte[] value;

    public Int(byte value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(Byte.BYTES).put(value).array();
    }

    public Int(short value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(Short.BYTES).putShort(value).array();
    }

    public Int(int value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(Integer.BYTES).putInt(value).array();
    }

    public Int(long value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(Long.BYTES).putLong(value).array();
    }

    public Int(long value) {
        this.value = BigInteger.valueOf(value).toByteArray();
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getValue() {
        return toIntValue(value);
    }

    private int toIntValue(byte[] v) {
        return new BigInteger(v).intValue();
    }

    public byte[] readLength() throws IOException {
        int len = this.readInt();
        return this.readBytes(len);
    }

    public byte[] readString(int len) throws IOException {
        return this.readBytes(len);
    }

    /**
     * @param data 数据
     * @param len  定长的话传长度，非定长不传
     */
    public static Int getInstance(byte[] data, int... len) throws Exception {
        ByteArrayUtils.printHexBinary(null, "Int data", data);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        Int anInt;
        byte[] dest;
        if (len.length == 0) {
            if (length.intValue() - 0x80 > 0) {
                //len 长度
                BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 1, length.intValue() - 0x80);
                byte[] goal = new byte[integer.intValue()];
                System.arraycopy(data, 1 + (length.intValue() - 0x80), goal, 0, goal.length);
                ByteArrayUtils.printHexBinary(null, "Int real data", goal);
                BigInteger value = BigIntegers.fromUnsignedByteArray(goal);
                anInt = new Int(value.intValue());
                dest = new byte[data.length - 1 - (length.intValue() - 0x80) - integer.intValue()];
                System.arraycopy(data, 1 + (length.intValue() - 0x80) + integer.intValue(), dest, 0, dest.length);
                anInt.setGoal(dest);
            } else if (length.intValue() - 0x80 < 0) {
                byte[] goal = new byte[length.intValue()];
                System.arraycopy(data, 1, goal, 0, goal.length);
                ByteArrayUtils.printHexBinary(null, "Int real data", goal);
                BigInteger value = BigIntegers.fromUnsignedByteArray(goal);
                anInt = new Int(value.intValue());
                dest = new byte[data.length - 1 - length.intValue()];
                System.arraycopy(data, 1 + length.intValue(), dest, 0, dest.length);
                anInt.setGoal(dest);
            } else {
                throw new Exception("该数据类型不是Int");
            }
        } else {
            BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, len[0]);
            anInt = new Int(integer.intValue(), len[0]);
            dest = new byte[data.length - len[0]];
            System.arraycopy(data, len[0], dest, 0, dest.length);
            anInt.setGoal(dest);
        }

        return anInt;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        if (this.length != -1) {
            if (value.length > this.length) {
                throw new IOException("value len:" + value.length + " is greater than " + length);
            }
        } else {
            this.setLengthPrefix(value.length);
        }
        vector.add(value);
        return vector;
    }

}
