package com.xdja.pki.itsca.oer.asn1.base;

import java.io.IOException;
import java.util.Vector;

/**
 * Uint8 ::= INTEGER (0..255)
 * 如果下界值范围约束的是不小于0和上限不大于255并且约束是不可扩展的，整数值被编码为 无符号 在二进制整数 一个八位字节;
 *
 * uintN_t	bits	bytes	对应Java实现
 * uint8_t	8	    1	    short
 * uint16_t	16	    2	    int
 * uint32_t	32	    4	    long
 */
public class Uint8 extends OERObject {

    private int i;

    public Uint8(int i) throws IOException {
        this((short) i);
    }

    public Uint8(short i) throws IOException {
        if (i <= 255 && i >= 0){
            this.i = i;
        } else {
            throw new IOException("Uint8 must in 0-255");
        }
    }

    public Uint8() {

    }

    public static Uint8 getInstance(byte[] obj) {
        Uint8 uint8 = new Uint8();
        uint8.fromByteArray(obj);
        return uint8;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        vector.add(i);
        return vector;
    }
}
