package com.xdja.pki.itsca.oer.cert.bean;

/**
 * @ClassName CertHashType
 * @Date 2019/8/14 18:56
 * @Author FengZhen
 */
public enum CertHashType {
    /**
     * SGD_SM3
     */
    SGD_SM3(0, "SGD_SM3"),
    /**
     * SHA_256
     */
    SHA_256(1, "SHA_256");


    public int id;
    public String value;

    private CertHashType(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static CertHashType getCertHashType(int id) {
        for (CertHashType t : CertHashType.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("CertHashType 枚举转换异常[id=%d]", id));
    }

    public static String CertHashType(int id) {
        for (CertHashType t : CertHashType.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("CertHashType 枚举转换异常[id=%d]", id));
    }
}
