package com.xdja.pki.itsca.oer.cert.bean;

/**
 * @ClassName IssueIdType
 * @Date 2019/8/15 9:12
 * @Author FengZhen
 */
public enum  IssueIdType {
    /**
     * 空
     */
    NULL(0, "空"),


    /**
     * 证书摘要
     */
    CERTIFICATE_DIGEST(1, "证书摘要");


    public int id;
    public String value;

    private IssueIdType(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id) {
        for (IssueIdType t : IssueIdType.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("IssueIdType 枚举转换异常[id=%d]", id));
    }

}
