package com.xdja.pki.itsca.oer.cert.bean;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ClassName OERCertRequest
 */
public class OERCertRequest {
    private String subjectName;
    private String subjectType;
    private Enumerated.Value type;
    private String startTime;
    private String endTime;
    private Date startDate;
    private Date endDate;
    private PublicKey signPublicKey;
    private PublicKey encPublicKey;
    private PublicKey snapPublic;
    private List<String> itsAid;
    private List<OERItsAidSsp> itsAidSspList;
    private GeographicRegionType regionType;
    private OERCircularRegion circularRegion = new OERCircularRegion();
    private List<OERRectangularRegion> rectangularRegions = new ArrayList<>();
    private List<OERPolygonalRegion> polygonalRegions = new ArrayList<>();

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public PublicKey getSignPublicKey() {
        return signPublicKey;
    }

    public void setSignPublicKey(PublicKey signPublicKey) {
        this.signPublicKey = signPublicKey;
    }

    public PublicKey getEncPublicKey() {
        return encPublicKey;
    }

    public void setEncPublicKey(PublicKey encPublicKey) {
        this.encPublicKey = encPublicKey;
    }

    public PublicKey getSnapPublic() {
        return snapPublic;
    }

    public void setSnapPublic(PublicKey snapPublic) {
        this.snapPublic = snapPublic;
    }

    public List<String> getItsAid() {
        return itsAid;
    }

    public void setItsAid(List<String> itsAid) {
        this.itsAid = itsAid;
    }

    public List<OERItsAidSsp> getItsAidSspList() {
        return itsAidSspList;
    }

    public void setItsAidSspList(List<OERItsAidSsp> itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public GeographicRegionType getRegionType() {
        return regionType;
    }

    public void setRegionType(GeographicRegionType regionType) {
        this.regionType = regionType;
    }

    public OERCircularRegion getCircularRegion() {
        return circularRegion;
    }

    public void setCircularRegion(OERCircularRegion circularRegion) {
        this.circularRegion = circularRegion;
    }

    public List<OERRectangularRegion> getRectangularRegions() {
        return rectangularRegions;
    }

    public void setRectangularRegions(List<OERRectangularRegion> rectangularRegions) {
        this.rectangularRegions = rectangularRegions;
    }

    public List<OERPolygonalRegion> getPolygonalRegions() {
        return polygonalRegions;
    }

    public void setPolygonalRegions(List<OERPolygonalRegion> polygonalRegions) {
        this.polygonalRegions = polygonalRegions;
    }

    public Enumerated.Value getType() {
        return type;
    }

    public void setType(Enumerated.Value type) {
        this.type = type;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String toString() {
        return "OERCertRequest{" +
                "subjectName='" + subjectName + '\'' +
                ", subjectType='" + subjectType + '\'' +
                ", type=" + type +
                ", startTime='" + startTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", signPublicKey=" + signPublicKey +
                ", encPublicKey=" + encPublicKey +
                ", snapPublic=" + snapPublic +
                ", itsAid=" + itsAid +
                ", itsAidSspList=" + itsAidSspList +
                ", regionType=" + regionType +
                ", circularRegion=" + circularRegion +
                ", rectangularRegions=" + rectangularRegions +
                ", polygonalRegions=" + polygonalRegions +
                '}';
    }
}
