package com.xdja.pki.itsca.oer.cert.bean;

import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 证书详情类
 */
public class OERCertificate {
    private int version;
    private TbsCert tbsCert;
    private String subjectName;
    private String signerHashId8;
    private String selfHashId8;
    private String selfHashId10;
    private IssueIdType issueIdType;
    private PublicKey signPublicKey;
    private String subjectType;
    private Enumerated.Value type;
    private CertHashType issueIdAlg;
    private byte[] signature;
    private String startTime;
    private String endTime;
    private Date startDate;
    private Date endDate;
    private List<String> itsAid;
    private List<OERItsAidSsp> itsAidSspList;
    private PublicKey encPublicKey;
    private GeographicRegionType regionType;
    private OERCircularRegion circularRegion = new OERCircularRegion();
    private List<OERRectangularRegion> rectangularRegions = new ArrayList<>();
    private List<OERPolygonalRegion> polygonalRegions = new ArrayList<>();

    public List<String> getItsAid() {
        return itsAid;
    }

    public void setItsAid(List<String> itsAid) {
        this.itsAid = itsAid;
    }

    public List<OERItsAidSsp> getItsAidSspList() {
        return itsAidSspList;
    }

    public void setItsAidSspList(List<OERItsAidSsp> itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public CertHashType getIssueIdAlg() {
        return issueIdAlg;
    }

    public void setIssueIdAlg(CertHashType issueIdAlg) {
        this.issueIdAlg = issueIdAlg;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public TbsCert getTbsCert() {
        return tbsCert;
    }

    public void setTbsCert(TbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSignerHashId8() {
        return signerHashId8;
    }

    public void setSignerHashId8(String signerHashId8) {
        this.signerHashId8 = signerHashId8;
    }

    public String getSelfHashId8() {
        return selfHashId8;
    }

    public void setSelfHashId8(String selfHashId8) {
        this.selfHashId8 = selfHashId8;
    }

    public PublicKey getSignPublicKey() {
        return signPublicKey;
    }

    public void setSignPublicKey(PublicKey signPublicKey) {
        this.signPublicKey = signPublicKey;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public byte[] getSignature() {
        return signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public PublicKey getEncPublicKey() {
        return encPublicKey;
    }

    public void setEncPublicKey(PublicKey encPublicKey) {
        this.encPublicKey = encPublicKey;
    }

    public GeographicRegionType getRegionType() {
        return regionType;
    }

    public void setRegionType(GeographicRegionType regionType) {
        this.regionType = regionType;
    }

    public OERCircularRegion getCircularRegion() {
        return circularRegion;
    }

    public void setCircularRegion(OERCircularRegion circularRegion) {
        this.circularRegion = circularRegion;
    }

    public List<OERRectangularRegion> getRectangularRegions() {
        return rectangularRegions;
    }

    public void setRectangularRegions(List<OERRectangularRegion> rectangularRegions) {
        this.rectangularRegions = rectangularRegions;
    }

    public List<OERPolygonalRegion> getPolygonalRegions() {
        return polygonalRegions;
    }

    public void setPolygonalRegions(List<OERPolygonalRegion> polygonalRegions) {
        this.polygonalRegions = polygonalRegions;
    }

    public IssueIdType getIssueIdType() {
        return issueIdType;
    }

    public void setIssueIdType(IssueIdType issueIdType) {
        this.issueIdType = issueIdType;
    }

    public String getSelfHashId10() {
        return selfHashId10;
    }

    public void setSelfHashId10(String selfHashId10) {
        this.selfHashId10 = selfHashId10;
    }

    public Enumerated.Value getType() {
        return type;
    }

    public void setType(Enumerated.Value type) {
        this.type = type;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String toString() {
        return "OERCertificate{" +
                "version=" + version +
                ", tbsCert=" + tbsCert +
                ", subjectName='" + subjectName + '\'' +
                ", signerHashId8='" + signerHashId8 + '\'' +
                ", selfHashId8='" + selfHashId8 + '\'' +
                ", selfHashId10='" + selfHashId10 + '\'' +
                ", issueIdType=" + issueIdType +
                ", signPublicKey=" + signPublicKey +
                ", subjectType='" + subjectType + '\'' +
                ", type=" + type +
                ", issueIdAlg=" + issueIdAlg +
                ", signature=" + Arrays.toString(signature) +
                ", startTime='" + startTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", itsAid=" + itsAid +
                ", itsAidSspList=" + itsAidSspList +
                ", encPublicKey=" + encPublicKey +
                ", regionType=" + regionType +
                ", circularRegion=" + circularRegion +
                ", rectangularRegions=" + rectangularRegions +
                ", polygonalRegions=" + polygonalRegions +
                '}';
    }
}