package com.xdja.pki.itsca.oer.utils;

import org.bouncycastle.asn1.*;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.Enumeration;

/***
 * GM/T 0009-2012 7.2 加密数据结构
 *
 * SM2Cipher :: = SEQUENCE {
 *     XCoordinate  INTEGER,    -- x 分量
 *     YCoordinate  INTEGER,    -- y 分量
 *     HASH         OCTET STRING SIZE(32),  -- 杂凑值
 *     CipherText   OCTET STRING            -- 密文
 * }
 *
 * HASH 位使用SM3算法对明文数据运算得到的杂凑值，其长度固定为 256 位
 * CipherText 是与明文等长的密文
 */
public class ASN1SM2Cipher extends ASN1Object {

    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private ASN1OctetString hash;
    private ASN1OctetString cipherText;

    public static ASN1SM2Cipher getInstance(Object o) {
        if (o instanceof ASN1SM2Cipher) {
            return (ASN1SM2Cipher) o;
        } else if (o != null) {
            return new ASN1SM2Cipher(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public ASN1SM2Cipher(ASN1Sequence sm2Asn1Sequence) {
        Enumeration e = sm2Asn1Sequence.getObjects();
        xCoordinate = ASN1Integer.getInstance(e.nextElement());
        yCoordinate = ASN1Integer.getInstance(e.nextElement());
        hash = ASN1OctetString.getInstance(e.nextElement());
        cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public ASN1SM2Cipher(ASN1Integer xCoordinate, ASN1Integer yCoordinate, ASN1OctetString hash, ASN1OctetString cipherText) {
        super();
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.hash = hash;
        this.cipherText = cipherText;
    }

    public ASN1SM2Cipher(byte[] x, byte[] y, byte[] hash, byte[] cipherText) {
        super();
        this.xCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray(x));
        this.yCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray(y));
        this.hash = new DEROctetString(hash);
        this.cipherText = new DEROctetString(cipherText);
    }

    public BigInteger getxCoordinate() {
        return xCoordinate.getPositiveValue();
    }

    public BigInteger getyCoordinate() {
        return yCoordinate.getPositiveValue();
    }

    public byte[] getHash() {
        return hash.getOctets();
    }

    public byte[] getCipherText() {
        return cipherText.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(xCoordinate);
        vector.add(yCoordinate);
        vector.add(hash);
        vector.add(cipherText);
        return new DERSequence(vector);
    }
}