package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;

public class SecuredMessageBuilder {
    private static Logger logger = LoggerFactory.getLogger(SecuredMessageBuilder.class);

    public static SecuredMessage buildSignedDataSecuredMessage(
            ItsAidInt itsAidInt,
            PrivateKey caPrivateKey,
            Certificate caCertificate,
            byte[] data
    ) throws Exception {
        SecuredMessage sign = new SecuredMessage();
        SignedData signedData = new SignedData();

        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        sequenceOfCertificate.addCertificate(caCertificate);
        SignerInfo signerInfo = new SignerInfo(sequenceOfCertificate);
        signedData.setSignerInfo(signerInfo);

        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(itsAidInt);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        signedData.setTbs(tbsData);

        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ecaEncode = caCertificate.getEncode();
        byte[] ecaHash =  GMSSLSM3DigestUtils.digestByYunhsm(ecaEncode);
       // byte[] pcaHash = BCUtils.sm3DigestByBC(pcaEncode);

        byte[] tbsDataEncode = tbsData.getEncode();
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm(tbsDataEncode);
       // byte[] tbsHash = BCUtils.sm3DigestByBC(tbsDataEncode);
        bos.write(tbsHash);
        bos.write(ecaHash);
        Signature signature = SignatureBuild.build(caPrivateKey, bos.toByteArray());
        signedData.setSign(signature);

        Payload payload = new Payload(signedData);
        sign.setPayload(payload);
        return sign;
    }

    public static SecuredMessage buildEncryptedDataSecuredMessage(Certificate caCertificate, byte[] data) throws Exception {
        SecuredMessage enc = new SecuredMessage();
        byte[] key = GMSSLByteArrayUtils.base64Decode(GMSSLRandomUtils.generateRandomByYunhsm(16));
        //byte[] key = BCUtils.generateRandomByBC(16);
        EncryptedData encryptedData = new EncryptedData();

        SequenceOfRecipientInfo sequenceOfRecipientInfo = buildSequenceOfRecipientInfo(caCertificate, key);
        encryptedData.setRecipients(sequenceOfRecipientInfo);

        CipherText cipherText = new CipherText();
     //   byte[] cipher = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key, data);
          byte[] cipher = GMSSLSM4ECBEncryptUtils.sm4SymmetricWithPaddingByYunHsm(true,
                  SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, data);
        ByteArrayUtils.printHexBinary(logger, "cipher", cipher);
        cipherText.setString(cipher);

        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);

        Payload payload = new Payload(encryptedData);
        enc.setPayload(payload);
        ByteArrayUtils.printHexBinary(logger, "payload", payload.getEncode());
        logger.info("加密数据加密完成");
        return enc;
    }

    public static SequenceOfRecipientInfo buildSequenceOfRecipientInfo(Certificate caCertificate, byte[] key) throws Exception {
        // ECA证书 公钥加密 对称密钥
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        //证书数据的OER编码做HashID8计算并对
        byte[] certHash = GMSSLSM3DigestUtils.digestByYunhsm(caCertificate.getEncode());
       // byte[] certHash = BCUtils.sm3DigestByBC(caCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        EccPoint publicKey = caCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        logger.info("构建sequenceOfRecipientInfo完成");
        return sequenceOfRecipientInfo;
    }
}
