package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;

import java.io.IOException;
import java.security.PublicKey;

/**
 * @ClassName SignatureVerify
 * @Date 2019/7/23 22:08
 * @Author FengZhen
 */
public class SignatureVerify {
    public static boolean verify(PublicKey publicKey, byte[] data, Signature signature) throws IOException {
        byte[] r = signature.getR().getxOnly().getString();
        byte[] s = signature.getS().getString();
        ByteArrayUtils.printHexBinary(null, "r", r);
        ByteArrayUtils.printHexBinary(null, "s", s);
        ByteArrayUtils.printHexBinary(null, "sign content", data);
        byte[] sign = BCUtils.sm2SignDerEncode(r, s);
        try {
            //return BCUtils.sm2VerifyByBC(publicKey, data, sign);

            return GMSSLSM2SignUtils.verifyBySdfWithUserId(SdfCryptoType.YUNHSM, publicKey, "China".getBytes(), data, sign);
        } catch (Exception e) {
            return false;
        }
    }
}
