package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;

import java.security.PublicKey;

/***
 *  *NormalCertRequestSign ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		signedData(WITH COMPONENTS { ...,
 *  * 			signer(WITH COMPONENTS {
 *  * 				SequenceOfCertificate(SIZE(1))
 *  *                        }),
 *  * 			tbs(WITH COMPONENTS { ...,
 *  * 				headerInfo(WITH COMPONENTS { ...,
 *  * 					itsAid(40963),
 *  * 					hashAlg PRESENT,
 *  * 					genTime PRESENT,
 *  * 					expiryTime ABSENT,
 *  * 					digest ABSENT,
 *  * 					encKey  ABSENT
 *  *                }),
 *  * 				data( CONTAINING NormalCertRequestEnc ),
 *  * 				extHash  ABSENT
 *  *            })* 		})
 *  *    })
 *  * })
 *  * NormalCertRequestEnc ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		encData(WITH COMPONENTS { ...,
 *  * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 *  * 				RecipientInfo(WITH COMPONENTS {
 *  * 					certRecipInfo
 *  *                                })* 			}        ))
 *  *    })
 *  * 	})
 *  * })
 *  *
 */
public class NormalCertRequestEnc extends CertDataBuilder {
    /**
     * @param certRequest 证书请求
     * @param key         对称密钥 16位
     * @return NormalCertRespData   F.3.2　非注册证书应答数据格式
     */
    public SecuredMessage build(CertRequest certRequest, PublicKey publicKey, byte[] key) throws Exception {
        return buildSecuredMessage(certRequest, publicKey,false, key, certRequest.getEncode());
    }


    private SecuredMessage buildSecuredMessage(CertRequest certRequest, PublicKey publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();

        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        pkRecipientInfo.setHashAlg(hashAlg);
        //中的CertRequest数据的OER编码做HashID8计算并对
        //   byte[] certReqHash = BCUtils.sm3DigestByBC(certRequest.getEncode());
        byte[] certReqHash = GMSSLSM3DigestUtils.digestByBC(certRequest.getEncode());


        byte[] certHashId8 = new byte[8];
        System.arraycopy(certReqHash, certReqHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        ByteArrayUtils.printHexBinary(null, "hashID data ", certHashId8);
        HashedId8 recipientId = new HashedId8(certHashId8);
        //EnrollmentCertRespData->payload->encData->recipients->pkRecipientInfo->recipientId赋值，
        pkRecipientInfo.setRecipientId(recipientId);
        //构建kek
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        pkRecipientInfo.setKek(kek);

        EncryptedData encData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        RecipientInfo recipientInfo;
        if (isSignedDataRecip) {
            recipientInfo = new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.SIGNEDDATA_RECIPINFO);
        } else {
            recipientInfo = new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.CERT_RECIPINFO);
        }

        recipients.addRecipientInfo(recipientInfo);
        encData.setRecipients(recipients);
        //使用传入的key进行ECB加密数据
        //byte[] bytes = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key, data);
        byte[] bytes = GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, SdfAlgIdSymmetric.SGD_SM4_ECB, data);
        ByteArrayUtils.printHexBinary(null, "BCUtils bytes", bytes);
        CipherText cipherData = new CipherText();
        cipherData.setString(bytes);
        SymmetricCipherText cipherText = new SymmetricCipherText(cipherData);
        //写入密文
        encData.setCipherText(cipherText);
        Payload payload = new Payload(encData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}
