package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint8;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.crypto.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.List;
import java.util.Vector;

/***
 * -- 6.2.3 CRL
 *
 * Crl ::= SEQUENCE {
 *     version Uint8,
 *     issuerId IssuerId,
 *     unsignedCrl ToBeSignedCrl,
 *     signature Signature
 * }
 *
 */
public class CRL extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(CRL.class);

    private IssuerId issuerId;
    private ToBeSignedCrl toBeSignedCrl;
    private Signature signature;

    public CRL() {
        super(false, false);
    }

    public static CRL getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "CRL start data", data);
        CRL crl = new CRL();
        //去version
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        IssuerId issuerId = IssuerId.getInstance(data);
        data = issuerId.getGoal();
        ByteArrayUtils.printHexBinary(logger, "CRL issuerId data", issuerId.getEncode());
        ToBeSignedCrl toBeSignedCrl = ToBeSignedCrl.getInstance(data);
        data = toBeSignedCrl.getGoal();
        ByteArrayUtils.printHexBinary(logger, "CRL toBeSignedCrl data", toBeSignedCrl.getEncode());
        Signature signature = Signature.getInstance(data);
        data = signature.getGoal();
        ByteArrayUtils.printHexBinary(logger, "CRL signature data", signature.getEncode());
        crl.setToBeSignedCrl(toBeSignedCrl);
        crl.setSignature(signature);
        crl.setIssuerId(issuerId);
        crl.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "CRL lave data", crl.getGoal());
        return crl;
    }

    public IssuerId getIssuerId() {
        return issuerId;
    }

    public void setIssuerId(IssuerId issuerId) {
        this.issuerId = issuerId;
    }

    public ToBeSignedCrl getToBeSignedCrl() {
        return toBeSignedCrl;
    }

    public void setToBeSignedCrl(ToBeSignedCrl toBeSignedCrl) {
        this.toBeSignedCrl = toBeSignedCrl;
    }

    public Signature getSignature() {
        return signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(2);
        vector.add(issuerId);
        vector.add(toBeSignedCrl);
        vector.add(signature);
        return vector;
    }
}
