package com.xdja.pki.itsca.oer.asn1;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;

/**
 * HashAlgorithm ::= ENUMERATED {
 * sgdsm3,
 * sha256,
 * ...
 * }
 */
public class HashAlgorithm extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(HashAlgorithm.class);
    public static final Value SGD_SM3 = new Value(0, "SGD_SM3");
    public static final Value SHA_256 = new Value(1, "SHA_256");

    public HashAlgorithm(Value value) {
        super(value);
        this.addValueToList(SGD_SM3);
        this.addValueToList(SHA_256);
    }

    public static HashAlgorithm getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "HashAlgorithm start data", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        HashAlgorithm hashAlgorithm;
        if (choice.intValue() == 0) {
            logger.debug("HashAlgorithm choice SGD_SM3");
            hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        } else if (choice.intValue() == 1) {
            logger.debug("HashAlgorithm choice SHA_256");
            hashAlgorithm = new HashAlgorithm(HashAlgorithm.SHA_256);
        } else {
            logger.error("HashAlgorithm choice is error " + choice.intValue());
            throw new Exception("不支持的类型");
        }
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        hashAlgorithm.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "HashAlgorithm lave data", data);
        return hashAlgorithm;
    }

    public Value readValue() throws IOException {
        return super.readValue();
    }

}
