package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/***
 *
 * HashedId8 ::= OCTET STRING (SIZE (8))
 *
 * 说明：本 哈希值 用来识别证书等数据，首先计算输入数据的哈希值，然后从哈希值中取 8个最低 有效字节，
 * 最低的八个字节是 32 字节的 散列的 最后八个字节
 *
 */
public class HashedId8 extends OctetString {
    private static Logger logger = LoggerFactory.getLogger(HashedId8.class);

    public HashedId8(byte[] string) throws IOException {
        this.setLength(8);
        this.setString(string);
    }

    public static HashedId8 getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "HashedId8 start data", data);
        byte[] goal = new byte[8];
        System.arraycopy(data, 0, goal, 0, goal.length);
        HashedId8 hashedId8 = new HashedId8(goal);
        goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        hashedId8.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "HashedId8 lave data", data);
        return hashedId8;
    }
}
