package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

/**
 * -- 6.2.2.7 签名
 * <p>
 * Signature ::= SEQUENCE {
 * curve EccCurve,
 * r EccPoint,
 * s OCTET STRING(SIZE(32))
 * }
 */
public class Signature extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(Signature.class);
    private EccCurve eccCurve;
    private EccPoint r;
    private OctetString s;


    public Signature() {
        super(false, false);
    }

    public static Signature getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "Signature start data", data);
        Signature signature = new Signature();
        EccCurve eccCurve = EccCurve.getInstance(data);
        signature.setEccCurve(eccCurve);
        ByteArrayUtils.printHexBinary(logger, "Signature eccCurve data", eccCurve.getEncode());
        data = eccCurve.getGoal();
        EccPoint r = EccPoint.getInstance(data);
        signature.setR(r);
        data = r.getGoal();
        ByteArrayUtils.printHexBinary(logger, "Signature r data", r.getEncode());
        byte[] s = new byte[32];
        System.arraycopy(data, 0, s, 0, s.length);
        ByteArrayUtils.printHexBinary(logger, "Signature s data", s);
        byte[] goal = new byte[data.length - s.length];
        System.arraycopy(data, s.length , goal, 0, goal.length);
        signature.setS(s);
        signature.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "Signature lave data", signature.getGoal());
        return signature;
    }

    public EccCurve getEccCurve() {
        return eccCurve;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public EccPoint getR() {
        return r;
    }

    public void setR(byte[] r) throws IOException {
        EccPoint eccPoint = new EccPoint();
        OctetString xOnly = new OctetString();
        xOnly.setLength(32);
        xOnly.setString(r);
        eccPoint.setxOnly(xOnly);
        this.r = eccPoint;
    }

    public void setR(EccPoint r) {
        this.r = r;
    }

    public OctetString getS() {
        return s;
    }

    public void setS(OctetString s) {
        this.s = s;
    }

    public void setS(byte[] s) throws IOException {
        this.s = new OctetString();
        this.s.setLength(32);
        this.s.setString(s);
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(eccCurve);
        vector.add(r);
        vector.add(s);
        return vector;
    }
}
