package com.xdja.pki.itsca.oer.asn1.base;

import java.io.IOException;
import java.util.List;
import java.util.Vector;

public abstract class Sequence extends OERObject {

    protected BitByte optional = new BitByte();
    protected boolean isExtension;
    protected boolean hasOptional;

    public Sequence(boolean isExtension, boolean hasOptional) {
        this.isExtension = isExtension;
        this.hasOptional = hasOptional;
    }

//    public static Sequence getInstance(byte[] obj) {
//        Sequence sequence = new Sequence();
//        sequence.fromByteArray(obj);
//        return sequence;
//    }


    public void addOptional(List<Integer> indexes) {
        for (int index : indexes) {
            if (isExtension){
                this.optional.setIndex(index-1);
            } else {
                this.optional.setIndex(index);
            }
        }
    }

    public List<Integer> readOptional() throws IOException {
        return this.optional.readIndexes();
    }

    public abstract Vector getSequenceValues();

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        if (this.isExtension || this.hasOptional){
            vector.add(optional);
        }
        Vector sub = this.getSequenceValues();
        if (sub != null){
            for (Object obj: sub){
                if (obj != null){
                    vector.add(obj);
                }
            }
        }

        return vector;
    }


}
