package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

/**
 * Uint64 ::= INTEGER (0..18446744073709551615)
 * 如果下界是不小于0和上限不大于18446744073709551615并且约束是不可扩展的，整数值被编码为 无符号 在二进制整数 为八个八位组;
 */
public class Uint64 extends OERObject {
    private static Logger logger = LoggerFactory.getLogger(Uint64.class);
    private byte[] bytes;

    public Uint64(long l) throws IOException {
        this(BigInteger.valueOf(l));
    }

    public Uint64(String str) throws IOException {
        this(new BigInteger(str));
    }

    public Uint64(BigInteger i) throws IOException {
        this(BigIntegers.asUnsignedByteArray(i));
    }


    public static Uint64 getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "lave data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 8);
        Uint64 uint64 = new Uint64(integer.longValue());
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        uint64.setGoal(goal);
        return uint64;
    }

    public Uint64(byte[] byteArray) throws IOException {
        //compareTo方法来比较，小于则返回-1，等于则返回0，大于则返回1
        BigInteger integer = BigIntegers.fromUnsignedByteArray(byteArray);
        if (new BigInteger("18446744073709551615").compareTo(integer) >= 0
                && new BigInteger("0").compareTo(integer) <= 0) {
            if (byteArray.length > 8) {
                throw new IOException("Uint64 must less than 8 length");
            }
            bytes = new byte[Long.BYTES];
            System.arraycopy(byteArray, 0, bytes, bytes.length - byteArray.length, byteArray.length);
        } else {
            throw new IOException("Uint64 must in 0-18446744073709551616");
        }
    }

    private Uint64() {

    }

//    public static Uint64 getInstance(byte[] obj) {
//        Uint64 uint64 = new Uint64();
//        uint64.fromByteArray(obj);
//        return uint64;
//    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        vector.add(bytes);
        return vector;
    }
}