package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.cert.bean.*;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import sun.util.calendar.Gregorian;

import java.math.BigInteger;
import java.security.PublicKey;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

/**
 * 获取TBSCert详情
 */
public class TbsCertHolder {
    public static OERTbsCert build(byte[] data) throws Exception {
        TbsCert tbsCert = TbsCert.getInstance(data);
        OctetString subject = tbsCert.getSubjectInfo().getSubjectName();
        String subjectName = new String(subject.getString());
        PublicVerifyKey verifyKey = tbsCert.getSubjectAttribute().getVerifyKey();
        Uncompressed uncompressed = verifyKey.getEccPoint().getUncompressed();
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        PublicKey signPublicKey = X509Utils.convertSM2PublicKey(x, y);
        SubjectType subjectType = tbsCert.getSubjectInfo().getSubjectType();
        BigInteger type = BigIntegers.fromUnsignedByteArray(subjectType.getEncode());
        String subType = "";
        OERTbsCert oerTbsCert = new OERTbsCert();
        if (type.intValue() == 0) {
            subType = "注册证书";
            oerTbsCert.setType(SubjectType.ENROLLMENT_CREDENTIAL);
        } else if (type.intValue() == 1) {
            subType = "授权证书";
            oerTbsCert.setType(SubjectType.AUTHORIZATION_TICKET);
        } else if (type.intValue() == 2) {
            subType = "授权CA证书";
            oerTbsCert.setType(SubjectType.AUTHORIZATION_AUTHORITY);
        } else if (type.intValue() == 3) {
            subType = "注册CA证书";
            oerTbsCert.setType(SubjectType.ENROLLMENT_AUTHORITY);
        } else if (type.intValue() == 4) {
            subType = "根CA证书";
            oerTbsCert.setType(SubjectType.ROOT_CA);
        } else if (type.intValue() == 5) {
            subType = "CRL签发证书";
            oerTbsCert.setType(SubjectType.CRL_SIGNER);
        } else if (type.intValue() == 6) {
            subType = "假名证书";
            oerTbsCert.setType(SubjectType.PSEUDONYM_CERTIFICATE);
        } else if (type.intValue() == 7) {
            subType = "假名CA证书";
            oerTbsCert.setType(SubjectType.PSEUDONYM_AUTHORITY);
        } else {
            throw new Exception("unknown subject type " + type.intValue());
        }
        ValidityRestriction validityRestriction = tbsCert.getValidityRestriction();
        String startTime = "";
        String endTime = "";

        if (null != validityRestriction.getValidityPeriod().getTimeEnd()) {
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeEnd();
            BigInteger time = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(time.longValue()));
        }
        if (null != validityRestriction.getValidityPeriod().getTimeStartAndEnd()) {
            Time32 timeStart = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getStartValidity();
            BigInteger sTime = BigIntegers.fromUnsignedByteArray(timeStart.getEncode());
            startTime = TimeUtils.getTime(sTime.longValue());
            oerTbsCert.setStartDate(TimeUtils.getTimeFromNumber(sTime.longValue()));
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getEndValidity();
            BigInteger eTime  = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            endTime = TimeUtils.getTime(eTime.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(eTime.longValue()));
        }

        try {
            List<RectangularRegion> rectangularRegions = validityRestriction.getGeographicRegion().getRectangularRegion().getRectangularRegions();
            List<OERRectangularRegion> regions = new ArrayList<>();
            for (RectangularRegion rectangularRegion : rectangularRegions) {
                OERRectangularRegion region = new OERRectangularRegion();
                region.setNorthWestLatitude(rectangularRegion.getNorthWest().getLatitude().getValue());
                region.setNorthWestLongitude(rectangularRegion.getNorthWest().getLongitude().getValue());
                region.setSouthEastLatitude(rectangularRegion.getSouthEast().getLatitude().getValue());
                region.setSouthEastLongitude(rectangularRegion.getSouthEast().getLongitude().getValue());
                regions.add(region);
            }
            oerTbsCert.setRectangularRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.RECTANGULAR_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        try {
            CircularRegion circularRegion = validityRestriction.getGeographicRegion().getCircularRegion();
            OERCircularRegion region = new OERCircularRegion();
            BigInteger r = BigIntegers.fromUnsignedByteArray(circularRegion.getRadius().getEncode());
            region.setR(r.intValue());
            region.setLatitude(circularRegion.getCenter().getLatitude().getValue());
            region.setLongitude(circularRegion.getCenter().getLongitude().getValue());
            oerTbsCert.setCircularRegion(region);
            oerTbsCert.setRegionType(GeographicRegionType.CIRCULAR_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        try {
            List<TwoDLocation> twoDLocations = validityRestriction.getGeographicRegion().getPolygonalRegion().getTwoDLocations();
            List<OERPolygonalRegion> regions = new ArrayList<>();
            for (TwoDLocation twoDLocation : twoDLocations) {
                OERPolygonalRegion region = new OERPolygonalRegion();
                region.setLatitude(twoDLocation.getLatitude().getValue());
                region.setLongitude(twoDLocation.getLongitude().getValue());
                regions.add(region);
            }
            oerTbsCert.setPolygonalRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.POLYGONAL_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        List<String> itsAidList = new ArrayList<>();
        try {
            List<ItsAid> itsAid = tbsCert.getSubjectAttribute().getItsAidList().getItsAid();
            for (int i = 0; i < itsAid.size(); i++) {
                String s = Hex.toHexString(itsAid.get(i).getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                itsAidList.add(aid);
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
        List<OERItsAidSsp> sspList = new ArrayList<>();
        try {
            List<ItsAidSsp> itsAidSsp = tbsCert.getSubjectAttribute().getItsSspList().getItsAidSsp();
            for (int i = 0; i < itsAidSsp.size(); i++) {
                OERItsAidSsp ssp = new OERItsAidSsp();
                List<Integer> list = itsAidSsp.get(i).getServiceSpecificPermissionsList();
                ssp.setList(list);
                ItsAid itsAid = itsAidSsp.get(i).getItsAid();
                String s = Hex.toHexString(itsAid.getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                ssp.setItsAid(aid);
                sspList.add(ssp);
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
        try {
            PublicEncryptionKey encryptionKey = tbsCert.getSubjectAttribute().getEncryptionKey();
            uncompressed = encryptionKey.getPublicKey().getUncompressed();
            x = uncompressed.getX().getString();
            y = uncompressed.getY().getString();
            PublicKey encPublicKey = X509Utils.convertSM2PublicKey(x, y);
            oerTbsCert.setEncPublic(encPublicKey);
        } catch (Exception e) {
            //e.printStackTrace();
        }
        oerTbsCert.setItsAid(itsAidList);
        oerTbsCert.setItsAidSspList(sspList);
        oerTbsCert.setSubjectType(subType);
        oerTbsCert.setStartTime(startTime);
        oerTbsCert.setEndTime(endTime);
        oerTbsCert.setSignPublicKey(signPublicKey);
        oerTbsCert.setSubjectName(subjectName);
        return oerTbsCert;
    }
}
