/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlBeanDo;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.util.cri.SqlExpression;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertDao
extends BaseJdbcDao {
    public PageInfo getUserCertLists(Map<String, Object> param, Pager pager) {
        StringBuffer sqlBuffer = new StringBuffer();
        String selectColumns = " cert.subject,cert.sn,cert.type,cert.pair_cert_sn,cert.sign_alg, cert.status,cert.before_time, cert.gmt_create,cert.gmt_modified, cert.after_time,t.name tempname,racert.name raname ";
        String selectColumnsCount = "count(*)";
        String userCertJoinTable = "(select ra_cert.*,ra.name from ra_cert,ra where ra_cert.ra_id=ra.id) racert join template t join ";
        sqlBuffer.append("select " + selectColumns + " from " + userCertJoinTable);
        String userCertTable = "(select cert.not_before_time before_time, cert.not_after_time after_time,cert.* from cert) cert ";
        String userRevokeCertTable = "(select *,3 as status from revoked_cert where revoke_reason!=2) cert ";
        String userOutdateCertTable = "(select c.id,c.type,c.subject,c.sn,c.pair_cert_sn,c.not_before_time before_time,gmt_create gmt_create, gmt_modified gmt_modified, c.not_after_time after_time,c.sign_alg,c.template_id,4 as status from cert c where c.not_after_time< now() union all select r.id,r.type,r.subject,r.sn,r.pair_cert_sn,r.before_time,r.after_time,gmt_create gmt_create, gmt_modified gmt_modified, r.sign_alg,r.template_id,4 as status from revoked_cert r where r.after_time< now() union all select o.id,o.type,o.subject,o.sn,o.pair_cert_sn,o.before_time,o.after_time,gmt_create gmt_create, gmt_modified gmt_modified, o.sign_alg,o.template_id,4 as status from outdate_cert o) cert ";
        String userCertJoinOnStr = "on cert.type in (1,2) and racert.cert_id = cert.id and cert.template_id=t.id ";
        String aftertimeCondition = " and cert.after_time > now() ";
        String confirmStatusCondition = " and cert.confirmation_status=" + Constants.ISSUE_CERT_OK_ACK;
        Integer status = (Integer)param.get("status");
        switch (status) {
            case 3: {
                sqlBuffer.append(userRevokeCertTable);
                sqlBuffer.append(userCertJoinOnStr);
                sqlBuffer.append(aftertimeCondition);
                sqlBuffer.append(" AND revoke_reason <> ").append(6).append(" ");
                break;
            }
            case 4: {
                sqlBuffer.append(userOutdateCertTable);
                sqlBuffer.append(userCertJoinOnStr);
                break;
            }
            case 1: {
                sqlBuffer.append(userCertTable);
                sqlBuffer.append(userCertJoinOnStr);
                sqlBuffer.append(aftertimeCondition);
                sqlBuffer.append(confirmStatusCondition);
                break;
            }
            default: {
                sqlBuffer.append(userCertTable);
                sqlBuffer.append(userCertJoinOnStr);
                sqlBuffer.append(aftertimeCondition);
                sqlBuffer.append(confirmStatusCondition);
            }
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("certDn")))) {
            String certDNselect = " and cert.subject like '%" + (String)param.get("certDn") + "%'";
            sqlBuffer.append(certDNselect);
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("sn")))) {
            String snSelect = " and (cert.sn like '%" + (String)param.get("sn") + "%' or cert.pair_cert_sn like '%" + (String)param.get("sn") + "%')";
            sqlBuffer.append(snSelect);
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("raName")))) {
            String raNameselect = " and racert.name like '%" + (String)param.get("raName") + "%'";
            sqlBuffer.append(raNameselect);
        }
        sqlBuffer.append(" and cert.status = " + status);
        try {
            String sqlcount = sqlBuffer.toString().replaceFirst(selectColumns, selectColumnsCount);
            pager.setRecordCount(this.daoTemplate.queryForInt(sqlcount, null));
            this.logger.debug(sqlBuffer.toString());
            sqlBuffer.append(" order by cert.before_time desc");
            int pageNumber = pager.getPageNumber();
            int pageSize = pager.getPageSize();
            int offset = pager.getOffset();
            sqlBuffer.append(" limit " + offset + ", " + pageSize);
            List raCertList = this.daoTemplate.queryForList(sqlBuffer.toString(), null);
            this.logger.debug(sqlBuffer.toString());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setPageNo(pageNumber);
            pageInfo.setPageSize(pageSize);
            pageInfo.setRecordCount(pager.getRecordCount());
            pageInfo.setDatas((Collection)raCertList);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CertDO save(CertDO certDO) {
        try {
            return (CertDO)this.daoTemplate.insert((Object)certDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updatePairCertId(Long id, Long pairCertId) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET pair_cert_id = :pairCertId WHERE ").append("id = :id ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("pairCertId", (Object)pairCertId);
            parameterSource.addValue("id", (Object)id);
            return this.daoTemplate.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u7b7e\u540d\u8bc1\u4e66\u914d\u5bf9\u7684SN\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CertDO> getCertsBySignSn(String signSn, Integer alg) {
        try {
            Cnd cnd = Cnd.where((SqlExpression)Cnd.exps((String)"sn", (String)"=", (Object)signSn).or("pair_cert_sn", "=", (Object)signSn)).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return this.daoTemplate.query(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u83b7\u53d6\u53cc\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }

    public CertDO getCertBySignSn(String signSn, Integer alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)signSn).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return (CertDO)this.daoTemplate.fetch(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }

    public CertDO getCertBySignSnNoAck(String signSn, String alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)signSn).and("public_key_alg", "=", (Object)alg);
            return (CertDO)this.daoTemplate.fetch(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }

    public void deleteBatch(List<CertDO> certs) {
        try {
            this.daoTemplate.delete(certs);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u5220\u9664\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateCertStatus(String signSn, int status) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET status=:status ").append(",gmt_modified =:modifyTime ");
            if (CertStatusEnum.FROZEN.value == status) {
                sqlBuffer.append(", frozen_num=frozen_num+1 ");
            }
            sqlBuffer.append("WHERE sn=:signSn OR pair_cert_sn=:signSn");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("signSn", (Object)signSn);
            params.addValue("status", (Object)status);
            params.addValue("modifyTime", (Object)new Date());
            this.daoTemplate.executeSql(sqlBuffer.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updatePriCertStatus(String signSn, String encSn) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET confirmation_status = :status, gmt_modified = :modifyTime ").append("WHERE sn = :signSn  ").append("OR  pair_cert_sn = :signSn ").append("AND confirmation_status = :srcStatus");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("status", (Object)Constants.ISSUE_CERT_OK_ACK);
            parameterSource.addValue("srcStatus", (Object)Constants.ISSUE_CERT_NO_ACK);
            parameterSource.addValue("signSn", (Object)signSn);
            parameterSource.addValue("encSn", (Object)encSn);
            parameterSource.addValue("modifyTime", (Object)new Date());
            return this.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u5199\u5361\u72b6\u6001", (Throwable)e);
        }
    }

    public List<CertDO> getExpiredCerts() {
        try {
            Cnd cnd = Cnd.where((String)"notAfterTime", (String)"<", (Object)new Date());
            return this.daoTemplate.query(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u8fc7\u671f\u7684\u8bc1\u4e66\u5217\u8868", (Throwable)e);
        }
    }

    public List<CertDO> getCertsByTemplateId(long templateId) {
        try {
            Cnd cnd = Cnd.where((String)"template_id", (String)"=", (Object)templateId).and("crl_temp_id", "=", null);
            return this.daoTemplate.query(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u627e\u67d0\u8bc1\u4e66\u6a21\u677f\u5bf9\u5e94\u7684\u7528\u6237\u8bc1\u4e66", (Throwable)e);
        }
    }

    public List<CertDO> queryCertByIds(List<Long> ids) {
        try {
            return this.daoTemplate.query(CertDO.class, (Condition)Cnd.where((String)"id", (String)"IN", ids).or("pairCertId", "IN", ids));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66\u6570\u636e\u5e93Id\u5217\u8868\u67e5\u8be2\u5bf9\u5e94\u8bc1\u4e66\u53ca\u914d\u5bf9\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CertDO getCertById(Long oldCertId) {
        return (CertDO)this.daoTemplate.fetch(CertDO.class, oldCertId.longValue());
    }

    public boolean isOpenCrl(String sn) {
        String sql = "SELECT open_crl FROM template t LEFT JOIN cert c ON t.id = c.template_id WHERE c.sn=:sn ";
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("sn", (Object)sn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params) != 0;
    }

    public CertDO getCertBySn(String sn, Integer alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return (CertDO)this.daoTemplate.fetch(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }

    public CertDO getCertByPairCertId(Long pairCertId) {
        try {
            Cnd cnd = Cnd.where((String)"pair_cert_id", (String)"=", (Object)pairCertId).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return (CertDO)this.daoTemplate.fetch(CertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }

    public int updateOldCertPairInfo(String sn, Long pairCertId, String pairCertSn) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET pair_cert_sn = :pairCertSn , pair_cert_id =:pairCertId WHERE ").append("sn = :sn ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("pairCertId", (Object)pairCertId);
            parameterSource.addValue("pairCertSn", (Object)pairCertSn);
            parameterSource.addValue("sn", (Object)sn);
            return this.daoTemplate.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u914d\u5bf9\u7684\u8bc1\u4e66\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateRecoverySignCertStatus(String signSn) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET confirmation_status = :status, gmt_modified = :modifyTime ").append("WHERE  sn = :signSn  AND confirmation_status = :srcStatus");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("status", (Object)Constants.ISSUE_CERT_OK_ACK);
            parameterSource.addValue("srcStatus", (Object)Constants.ISSUE_CERT_NO_ACK);
            parameterSource.addValue("signSn", (Object)signSn);
            parameterSource.addValue("modifyTime", (Object)new Date());
            return this.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u5199\u5361\u72b6\u6001", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForCrl(Integer alg, Date thisUpdateDate) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial,").append(6).append(" reason, gmt_modified revocationDate FROM cert ").append("WHERE public_key_alg = :alg AND not_after_time >= now() ").append("AND gmt_create <= :time ").append("AND status = :status ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            parameterSource.addValue("status", (Object)CertStatusEnum.FROZEN.value);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1CRL\u6240\u9700\u7684\u51bb\u7ed3\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Long getMaxSnByTemplateId(Long crlTempId) {
        String sql = "select sn from cert where id = (select max(id) from cert where crl_temp_id=:crlTempId )";
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("crlTempId", (Object)crlTempId);
        String sn = this.daoTemplate.queryForString(sql, (SqlParameterSource)parameterSource);
        if (sn == null) {
            return null;
        }
        return Long.parseLong(sn, 16);
    }

    public void updateCertCrlTempIdAndSegmentNo(long certId, long crlTempId, int segmentNo) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE cert SET crl_temp_id=:crlTempId ,segment_no =:segmentNo where id=:certId");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("crlTempId", (Object)crlTempId);
            params.addValue("segmentNo", (Object)segmentNo);
            params.addValue("certId", (Object)certId);
            this.daoTemplate.executeSql(sqlBuffer.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

