/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertDataDao
extends BaseJdbcDao {
    public void saveBatch(List<CertDataDO> certList) {
        try {
            this.daoTemplate.insert(certList);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u63d2\u5165\u8bc1\u4e66\u6570\u636e\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CertDataDO queryCertDataById(Long id) {
        try {
            Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
            return (CertDataDO)this.daoTemplate.fetch(CertDataDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eId\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<String> getUserCert(String sn, int keyAlg) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            int[] types = new int[]{2, 1};
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg).and("type", "IN", (Object)types).and("confirmationStatus", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            CertDO cert = (CertDO)this.daoTemplate.fetch(CertDO.class, (Condition)cnd);
            if (null != cert) {
                result.add(String.valueOf(cert.getCaCertId()));
                result.add(cert.getSubject());
                return this.buildUserCertResult(cert.getId(), cert.getPairCertId(), result);
            }
            cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg).and("type", "IN", (Object)types);
            RevokedCertDO revokeCert = (RevokedCertDO)this.daoTemplate.fetch(RevokedCertDO.class, (Condition)cnd);
            if (null != revokeCert) {
                result.add(String.valueOf(revokeCert.getCaCertId()));
                result.add(revokeCert.getSubject());
                return this.buildUserCertResult(revokeCert.getId(), revokeCert.getPairCertId(), result);
            }
            OutdateCertDO outdateCert = (OutdateCertDO)this.daoTemplate.fetch(OutdateCertDO.class, (Condition)cnd);
            if (null != outdateCert) {
                result.add(String.valueOf(outdateCert.getCaCertId()));
                result.add(outdateCert.getSubject());
                return this.buildUserCertResult(outdateCert.getId(), outdateCert.getPairCertId(), result);
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u5e8f\u5217\u53f7\u3001\u5bc6\u94a5\u7b97\u6cd5\u83b7\u53d6\u7528\u6237\u5b9e\u4f53\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<String> buildUserCertResult(Long signCertId, Long encCertId, List<String> result) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(signCertId);
        if (null != encCertId) {
            ids.add(encCertId);
        }
        Map<Long, String> certs = this.getUserCertData(ids);
        result.add(certs.get(signCertId));
        if (null != encCertId) {
            result.add(certs.get(encCertId));
        }
        return result;
    }

    public Map<Long, String> getUserCertData(List<Long> ids) {
        try {
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            final HashMap<Long, String> result = new HashMap<Long, String>();
            String sql = "SELECT id, data FROM cert_data WHERE id IN (:ids)";
            this.daoTemplate.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("ids", ids), (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowId) throws SQLException {
                    do {
                        result.put(rs.getLong("id"), rs.getString("data"));
                    } while (rs.next());
                    return null;
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66Id\u5217\u8868\u67e5\u8be2\u7528\u6237\u5b9e\u4f53\u8bc1\u4e66\u539f\u6587\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

