/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CertStatusSyncDO;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertStatusSyncDao
extends BaseJdbcDao {
    public void saveBatchCertStatus(List<CertStatusSyncDO> list) {
        try {
            ArrayList<CertStatusSyncDO> otherList = new ArrayList<CertStatusSyncDO>();
            for (int i = 0; i < list.size(); ++i) {
                CertStatusSyncDO certStatusSyncDO = list.get(i);
                if (null == certStatusSyncDO.getCertId()) {
                    otherList.add(certStatusSyncDO);
                    continue;
                }
                this.saveORUpdateCertStatusSync(certStatusSyncDO);
            }
            this.daoTemplate.insert(otherList);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58\u5f85\u540c\u6b65\u8bc1\u4e66\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveORUpdateCertStatusSync(CertStatusSyncDO certStatusSyncDO) {
        try {
            Cnd cnd = Cnd.where((String)"cert_id", (String)"=", (Object)certStatusSyncDO.getCertId());
            List certStatusSyncs = this.daoTemplate.query(CertStatusSyncDO.class, (Condition)cnd);
            if (null != certStatusSyncs && certStatusSyncs.size() > 0) {
                CertStatusSyncDO old = (CertStatusSyncDO)certStatusSyncs.get(0);
                old.setGmtCreate(certStatusSyncDO.getGmtCreate());
                old.setRevokeReason(certStatusSyncDO.getRevokeReason());
                old.setStatus(certStatusSyncDO.getStatus());
                this.daoTemplate.insertORUpdate((Object)old);
            } else {
                this.daoTemplate.insert((Object)certStatusSyncDO);
            }
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58\u5f85\u540c\u6b65\u8bc1\u4e66\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CertStatusSyncDO> queryCertStatSyncForlist(int status) {
        List CertStatusSyncs = null;
        try {
            CertStatusSyncs = this.daoTemplate.query(CertStatusSyncDO.class, (Condition)Cnd.where((String)"status", (String)"=", (Object)status));
        }
        catch (Exception e) {
            throw new DAOException("CertStatusSyncDao\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u72b6\u6001\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return CertStatusSyncs;
    }

    public List<CertStatusSyncDO> queryPublishCert() {
        List CertStatusSyncs = null;
        try {
            CertStatusSyncs = this.daoTemplate.query(CertStatusSyncDO.class, (Condition)Cnd.where((String)"root_cert_id", (String)"IS", null));
        }
        catch (Exception e) {
            throw new DAOException("CertStatusSyncDao\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u72b6\u6001\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return CertStatusSyncs;
    }

    public List<CertStatusSyncDO> queryCACertUpdateForList(int status) {
        List certStatusSyncs = null;
        try {
            certStatusSyncs = this.daoTemplate.query(CertStatusSyncDO.class, (Condition)Cnd.where((String)"status", (String)"=", (Object)status).and("root_cert_id", "NOT IS", null));
        }
        catch (Exception e) {
            throw new DAOException("CertStatusSyncDao\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u72b6\u6001\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return certStatusSyncs;
    }

    public void deleteBatch(List<CertStatusSyncDO> certs) {
        try {
            this.daoTemplate.delete(certs);
        }
        catch (Exception e) {
            throw new DAOException("CertStatusSyncDao\u6279\u91cf\u5220\u9664\u8bc1\u4e66\u72b6\u6001\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public int deleteNotConfirmCertSync(Long userSignCertId, Long manageSignCertId) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM not_confirm_cert_sync WHERE ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            if (null != userSignCertId) {
                stringBuffer.append("cert_id = :certId ");
                parameterSource.addValue("certId", (Object)userSignCertId);
            }
            if (null != manageSignCertId) {
                stringBuffer.append("manage_id = :manageId");
                parameterSource.addValue("manageId", (Object)manageSignCertId);
            }
            return this.daoTemplate.executeSql(stringBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DaoException("\u4ece30s\u8d85\u65f6\u65f6\u95f4\u8868\u4e2d\u5220\u9664\u6570\u636e\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteDataByRootCertId(Long caCertId) {
        String sql = "delete from cert_status_sync where root_cert_id = :caCertId";
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("caCertId", (Object)caCertId);
        this.daoTemplate.deleteBySql(sql, (SqlParameterSource)parameterSource);
    }
}

