/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CertUpdateBaseInfoDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Date;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.util.cri.SqlExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ManagerCertDao
extends BaseJdbcDao {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ManageCertDO save(ManageCertDO manageCertDO) {
        try {
            return (ManageCertDO)this.daoTemplate.insert((Object)manageCertDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5230\u6570\u636e\u5e93\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updatePairCertId(Long id, Long pairCertId) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE manage_cert SET pair_cert_id = :pairCertId WHERE ").append("id = :id ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("pairCertId", (Object)pairCertId);
            parameterSource.addValue("id", (Object)id);
            return this.daoTemplate.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u52a0\u5bc6\u8bc1\u4e66\u914d\u5bf9\u7684\u8bc1\u4e66Id\u5230\u6570\u636e\u5e93\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public ManageCertDataDO queryCertDataNoById(Long id) {
        try {
            Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
            return (ManageCertDataDO)this.daoTemplate.fetch(ManageCertDataDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66ID\u67e5\u8be2\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ManageCertDO> getCertsBySignSn(String sn, Integer alg) {
        try {
            Cnd cnd = Cnd.where((SqlExpression)Cnd.exps((String)"sn", (String)"=", (Object)sn).or("pair_cert_sn", "=", (Object)sn)).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return this.daoTemplate.query(ManageCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u548c\u7b97\u6cd5\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ManageCertDO> getCertsByNotAclSignSn(String sn, String alg) {
        try {
            Cnd cnd = Cnd.where((SqlExpression)Cnd.exps((String)"sn", (String)"=", (Object)sn).or("pair_cert_sn", "=", (Object)sn)).and("public_key_alg", "=", (Object)alg);
            return this.daoTemplate.query(ManageCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eDN\u548c\u7b97\u6cd5\u4fe1\u606f\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteBatch(List<ManageCertDO> certs) {
        try {
            this.daoTemplate.delete(certs);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u5220\u9664\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CertUpdateBaseInfoDO getCertUpdateBaseInfo(String signSn, String alg) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT mc.subject certDn, mc.sign_alg signAlg, mc.public_key_alg keyAlg, mc.private_key_size keyAlgLength, mc.before_time beforeTime, mc.after_time afterTime, t.max_validity maxValidity ").append("FROM manage_cert mc LEFT JOIN template t ").append("ON mc.template_id = t.id ").append("WHERE mc.sn = :signSn AND mc.public_key_alg = :alg ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("signSn", (Object)signSn);
            parameterSource.addValue("alg", (Object)alg);
            return (CertUpdateBaseInfoDO)this.daoTemplate.queryForObject(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)new BeanPropertyRowMapper(CertUpdateBaseInfoDO.class));
        }
        catch (EmptyResultDataAccessException ede) {
            this.logger.info("\u6839\u636e\u5e8f\u5217\u53f7\u548csn\u67e5\u8be2\u8bc1\u4e66\u57fa\u672c\u7b97\u6cd5\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8bc1\u4e66\u4fe1\u606f,signSn=" + signSn);
            return null;
        }
        catch (DAOException e) {
            throw new ServiceException("\u6839\u636e\u5e8f\u5217\u53f7\u548csn\u67e5\u8be2\u8bc1\u4e66\u57fa\u672c\u7b97\u6cd5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public ManageCertDO getManagerCertsBySn(String sn, int alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            return (ManageCertDO)this.daoTemplate.fetch(ManageCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eSN\u548c\u7b97\u6cd5\u90a3\u4fe1\u606f\u67e5\u8be2\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public ManageCertDO getManagerCertsBySnNotAck(String sn, int alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("public_key_alg", "=", (Object)alg).and("confirmation_status", "=", (Object)Constants.ISSUE_CERT_NO_ACK);
            return (ManageCertDO)this.daoTemplate.fetch(ManageCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eSN\u548c\u7b97\u6cd5\u90a3\u4fe1\u606f\u67e5\u8be2\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public List<ManageCertDO> getExpiredManageCerts() {
        try {
            Cnd cnd = Cnd.where((String)"afterTime", (String)"<", (Object)new Date());
            return this.daoTemplate.query(ManageCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u8fc7\u671f\u7684\u7ba1\u7406\u8bc1\u4e66\u5217\u8868\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ManageCertDO> queryCertByIds(List<Long> ids) {
        try {
            return this.daoTemplate.query(ManageCertDO.class, (Condition)Cnd.where((String)"id", (String)"IN", ids).or("pairCertId", "IN", ids));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66\u6570\u636e\u5e93Id\u5217\u8868\u67e5\u8be2\u5bf9\u5e94\u8bc1\u4e66\u53ca\u914d\u5bf9\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ManageCertDO getManagerCertById(Long oldCertId) {
        try {
            return (ManageCertDO)this.daoTemplate.fetch(ManageCertDO.class, oldCertId.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66ID\u67e5\u8be2\u7ba1\u7406\u7c7b\u8bc1\u4e66\u4fe1\u606f", (Throwable)e);
        }
    }
}

