/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ManagerCertDataDao
extends BaseJdbcDao {
    public void batchSave(List<ManageCertDataDO> certList) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT manage_cert_data VALUES (").append(":id, :data, :gmt_create )");
            MapSqlParameterSource[] mapSqlParameterSources = new MapSqlParameterSource[certList.size()];
            MapSqlParameterSource mapSqlParameterSource = null;
            for (int i = 0; i < certList.size(); ++i) {
                ManageCertDataDO manageCertDataDO = certList.get(i);
                mapSqlParameterSource = new MapSqlParameterSource();
                mapSqlParameterSource.addValue("id", (Object)manageCertDataDO.getId());
                mapSqlParameterSource.addValue("data", (Object)manageCertDataDO.getData());
                mapSqlParameterSource.addValue("gmt_create", (Object)manageCertDataDO.getGmtCreate());
                mapSqlParameterSources[i] = mapSqlParameterSource;
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])mapSqlParameterSources);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u63d2\u5165\u8bc1\u4e66\u6570\u636e\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<String> getManageCert(String sn, int keyAlg) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg).and("type", "=", (Object)Constants.SIGN_CERT).and("confirmationStatus", "=", (Object)Constants.ISSUE_CERT_OK_ACK);
            ManageCertDO manageCert = (ManageCertDO)this.daoTemplate.fetch(ManageCertDO.class, (Condition)cnd);
            if (null != manageCert) {
                result.add(String.valueOf(manageCert.getCaCertId()));
                return this.buildManageCertResult(manageCert.getId(), manageCert.getPairCertId(), manageCert.getSubject(), result);
            }
            cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg).and("type", "=", (Object)Constants.SIGN_CERT);
            RevokedManageCertDO revokeCert = (RevokedManageCertDO)this.daoTemplate.fetch(RevokedManageCertDO.class, (Condition)cnd);
            if (null != revokeCert) {
                result.add(String.valueOf(revokeCert.getCaCertId()));
                return this.buildManageCertResult(revokeCert.getId(), revokeCert.getPairCertId(), revokeCert.getSubject(), result);
            }
            OutdateManageCertDO outdateCert = (OutdateManageCertDO)this.daoTemplate.fetch(OutdateManageCertDO.class, (Condition)cnd);
            if (null != outdateCert) {
                result.add(String.valueOf(outdateCert.getCaCertId()));
                return this.buildManageCertResult(outdateCert.getId(), outdateCert.getPairCertId(), outdateCert.getSubject(), result);
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u5e8f\u5217\u53f7\u3001\u5bc6\u94a5\u7b97\u6cd5\u83b7\u53d6\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<String> buildManageCertResult(long signCertId, long encCertId, String dn, List<String> result) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(signCertId);
        ids.add(encCertId);
        Map<Long, String> certs = this.getManageCertData(ids);
        result.add(certs.get(signCertId));
        result.add(certs.get(encCertId));
        result.add(dn);
        return result;
    }

    public Map<Long, String> getManageCertData(List<Long> ids) {
        try {
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            final HashMap<Long, String> result = new HashMap<Long, String>();
            String sql = "SELECT id, data FROM manage_cert_data WHERE id IN (:ids)";
            this.daoTemplate.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("ids", ids), (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowId) throws SQLException {
                    do {
                        result.put(rs.getLong("id"), rs.getString("data"));
                    } while (rs.next());
                    return null;
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66Id\u5217\u8868\u67e5\u8be2\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u539f\u6587\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ManageCertDataDO queryManagerCertDataById(Long id) {
        try {
            return (ManageCertDataDO)this.daoTemplate.fetch(ManageCertDataDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eId\u67e5\u8be2\u7ba1\u7406\u8bc1\u4e66\u6570\u636e\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void save(ManageCertDataDO data) {
        try {
            this.daoTemplate.insert((Object)data);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5bf9\u8c61\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

