/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.RaCertDO;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.List;
import java.util.Map;
import org.nutz.dao.DaoException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RaCertDao
extends BaseJdbcDao {
    public void saveBatch(List<RaCertDO> certList) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO ra_cert (ra_id, cert_id, gmt_create) VALUES (").append(":ra_id, :cert_id, :gmt_create)");
            MapSqlParameterSource[] mapSqlParameterSources = new MapSqlParameterSource[certList.size()];
            MapSqlParameterSource mapSqlParameterSource = null;
            for (int i = 0; i < certList.size(); ++i) {
                RaCertDO raCertDO = certList.get(i);
                mapSqlParameterSource = new MapSqlParameterSource();
                mapSqlParameterSource.addValue("ra_id", (Object)raCertDO.getRaId());
                mapSqlParameterSource.addValue("cert_id", (Object)raCertDO.getCertId());
                mapSqlParameterSource.addValue("gmt_create", (Object)raCertDO.getGmtCreate());
                mapSqlParameterSources[i] = mapSqlParameterSource;
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])mapSqlParameterSources);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u63d2\u5165ra\u8bc1\u4e66\u5173\u7cfb\u6620\u5c04\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> queryServerCertInfoBySignSn(String signSn, Integer alg) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT manageCert.status status, certData.data certData, serverCert.ra_id raId FROM manage_cert manageCert LEFT JOIN manage_cert_data certData ON  ").append("manageCert.id = certData.id LEFT JOIN ra_server_cert serverCert ON manageCert.id = serverCert.manage_cert_id ").append("WHERE manageCert.sn =:signSn AND public_key_alg =:alg");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("signSn", (Object)signSn);
            parameterSource.addValue("alg", (Object)alg);
            return this.daoTemplate.queryForMap(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
        catch (Exception e) {
            throw new DaoException("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

