/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlBeanDo;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RevokeCertDao
extends BaseJdbcDao {
    public void saveBatch(List<RevokedCertDO> revokedCertDOs) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO revoked_cert VALUES (").append(":id, :ca_cert_id, :sn, :subject, :issuer, :public_key_alg, :private_key_size, :before_time, :after_time, ").append(":sign_alg, :type, :is_revoke_key, :template_id, :pair_cert_id, :pair_cert_sn, :old_cert_id, :key_revoked_status, :key_not_before_time, ").append(":key_not_after_time, :revoke_reason, :revoke_note,:crl_temp_id,:segment_no, :gmt_create, :gmt_modified, :confirmation_status, :frozen_num)");
            MapSqlParameterSource[] mapSqlParameterSources = new MapSqlParameterSource[revokedCertDOs.size()];
            MapSqlParameterSource mapSqlParameterSource = null;
            for (int i = 0; i < revokedCertDOs.size(); ++i) {
                RevokedCertDO revokedCertDO = revokedCertDOs.get(i);
                mapSqlParameterSource = new MapSqlParameterSource();
                mapSqlParameterSource.addValue("id", (Object)revokedCertDO.getId());
                mapSqlParameterSource.addValue("ca_cert_id", (Object)revokedCertDO.getCaCertId());
                mapSqlParameterSource.addValue("sn", (Object)revokedCertDO.getSn());
                mapSqlParameterSource.addValue("subject", (Object)revokedCertDO.getSubject().toString());
                mapSqlParameterSource.addValue("issuer", (Object)revokedCertDO.getIssuer().toString());
                mapSqlParameterSource.addValue("public_key_alg", (Object)revokedCertDO.getPublicKeyAlg());
                mapSqlParameterSource.addValue("private_key_size", (Object)revokedCertDO.getPrivateKeySize());
                mapSqlParameterSource.addValue("before_time", (Object)revokedCertDO.getBeforeTime());
                mapSqlParameterSource.addValue("after_time", (Object)revokedCertDO.getAfterTime());
                mapSqlParameterSource.addValue("sign_alg", (Object)revokedCertDO.getSignAlg());
                mapSqlParameterSource.addValue("type", (Object)revokedCertDO.getType());
                mapSqlParameterSource.addValue("is_revoke_key", (Object)revokedCertDO.getIsRevokeKey());
                mapSqlParameterSource.addValue("template_id", (Object)revokedCertDO.getTemplateId());
                mapSqlParameterSource.addValue("pair_cert_id", (Object)revokedCertDO.getPairCertId());
                mapSqlParameterSource.addValue("pair_cert_sn", (Object)revokedCertDO.getPairCertSn());
                mapSqlParameterSource.addValue("old_cert_id", (Object)revokedCertDO.getOldCertId());
                mapSqlParameterSource.addValue("key_revoked_status", (Object)revokedCertDO.getKeyRevokedStatus());
                mapSqlParameterSource.addValue("key_not_before_time", (Object)revokedCertDO.getKeyNotBeforeTime());
                mapSqlParameterSource.addValue("key_not_after_time", (Object)revokedCertDO.getKeyNotAfterTime());
                mapSqlParameterSource.addValue("revoke_reason", (Object)revokedCertDO.getRevokeReason());
                mapSqlParameterSource.addValue("revoke_note", (Object)revokedCertDO.getRevokeNote());
                mapSqlParameterSource.addValue("crl_temp_id", (Object)revokedCertDO.getCrlTempId());
                mapSqlParameterSource.addValue("segment_no", (Object)revokedCertDO.getSegmentNo());
                mapSqlParameterSource.addValue("gmt_create", (Object)revokedCertDO.getGmtCreate());
                mapSqlParameterSource.addValue("gmt_modified", (Object)revokedCertDO.getGmtModified());
                mapSqlParameterSource.addValue("confirmation_status", (Object)revokedCertDO.getConfirmationStatus());
                mapSqlParameterSource.addValue("frozen_num", (Object)revokedCertDO.getFrozenNum());
                mapSqlParameterSources[i] = mapSqlParameterSource;
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])mapSqlParameterSources);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u64a4\u9500\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForCrl(String tmpLastMaxSn, String tmpUpdateMaxSn, Integer alg, Date thisUpdateDate) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM revoked_cert ").append("WHERE sn >= :tmpLastMaxSn AND sn <= :tmpUpdateMaxSn AND public_key_alg = :alg ").append("AND gmt_create <= :time");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("tmpLastMaxSn", (Object)tmpLastMaxSn);
            parameterSource.addValue("tmpUpdateMaxSn", (Object)tmpUpdateMaxSn);
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1CRL\u6240\u9700\u7684\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public RevokedCertDO getRevokeCertBySn(String signSn, Integer alg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)signSn).and("public_key_alg", "=", (Object)alg);
            return (RevokedCertDO)this.daoTemplate.fetch(RevokedCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esn\u67e5\u8be2\u88ab\u64a4\u9500\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForArl(Integer alg, Date thisUpdateDate) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("(SELECT caCert.sn userCertificateSerial, caCert.revoke_reason reason, caCert.gmt_create revocationDate FROM sub_ca_cert caCert ").append("WHERE caCert.public_key_alg = :alg ").append("AND caCert.gmt_create <= :time AND caCert.status = :status AND caCert.after_time > now() ) ").append("UNION (SELECT crossCert.sn userCertificateSerial, crossCert.revoke_reason reason, crossCert.gmt_create revocationDate FROM cross_cert crossCert ").append("WHERE crossCert.public_key_alg = :alg AND crossCert.gmt_create <= :time AND crossCert.status = :status AND crossCert.after_time > now() ) ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            parameterSource.addValue("status", (Object)2);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6ARL\u5206\u7247\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveCerts(List<RevokedCertDO> certs) {
        try {
            this.daoTemplate.insert(certs);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u64a4\u9500\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<RevokedCertDO> getExpiredCerts() {
        try {
            Cnd cnd = Cnd.where((String)"afterTime", (String)"<", (Object)new Date());
            return this.daoTemplate.query(RevokedCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u8fc7\u671f\u7684\u64a4\u9500\u8bc1\u4e66\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteBatch(List<RevokedCertDO> revokeCerts) {
        try {
            for (int i = 0; i < revokeCerts.size(); ++i) {
                this.daoTemplate.delete((Object)revokeCerts.get(i));
            }
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u5220\u9664\u8fc7\u671f\u7684\u64a4\u9500\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void delete(String sn) {
        try {
            String sql = "DELETE FROM revoked_cert WHERE sn=:sn OR pair_cert_sn=:sn";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("sn", (Object)sn);
            this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u64a4\u9500\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<RevokedCertDO> getPubKeyRevokeCerts() {
        try {
            return this.daoTemplate.query(RevokedCertDO.class, (Condition)Cnd.where((String)"type", (String)"=", (Object)CertDO.CertTypeEnum.ENC.value).and("isRevokeKey", "=", (Object)RevokedCertDO.IS_REVOKE_KEY.YES_REGOKE_KEY.value).and("keyRevokedStatus", "=", (Object)RevokedCertDO.KEY_REVOKE_STATUS.NO_KEY_REVOKE.value));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5bc6\u94a5\u64a4\u9500\u901a\u77e5\u7684\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }

    public void updatePubKeyRevokeStatus(RevokedCertDO pubKeyRevokeCert) {
        try {
            MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("id", (Object)pubKeyRevokeCert.getId());
            String sql = "update revoked_cert set key_revoked_status=" + RevokedCertDO.KEY_REVOKE_STATUS.YES_KEY_REGOKE.value + " where id=:id";
            this.daoTemplate.update(sql, (SqlParameterSource)paramSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u5bc6\u94a5\u64a4\u9500\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForCrl(Integer alg, Date thisUpdateDate, int begin, int end) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM revoked_cert ").append("WHERE public_key_alg = :alg AND after_time >= now() ").append("AND gmt_create <= :time ").append("order by id limit ").append(begin + "," + end + " ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1CRL\u6240\u9700\u7684\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> getApplyKeySn(String sn) {
        String sql = "SELECT rc.pair_cert_sn pairCertSn, rc.is_revoke_key isRevokeKey FROM revoked_cert rc where rc.id = (SELECT rcert.id FROM revoked_cert rcert WHERE rcert.sn = :sn)";
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("sn", (Object)sn);
        return this.daoTemplate.queryForMap(sql, (SqlParameterSource)parameterSource);
    }

    public RevokedCertDO getCertBySn(String sn) {
        return (RevokedCertDO)this.daoTemplate.fetch(RevokedCertDO.class, (Condition)Cnd.where((String)"sn", (String)"=", (Object)sn));
    }

    public RevokedCertDO getCertById(long id) {
        return (RevokedCertDO)this.daoTemplate.fetch(RevokedCertDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
    }

    public void updateRevokeCertStatus(List<CertDO> revokeCerts, int revokeRease, Date revokeDate, String revokeNote, int keyRevokeStatus) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE revoked_cert SET revoke_reason = :revokeRease, gmt_create = :gmCreate, key_revoked_status =:keyRevokeStatus ");
            if (StringUtils.isNotBlank((CharSequence)revokeNote)) {
                sqlBuffer.append(",revoke_note =:revokeNote ");
            }
            sqlBuffer.append("WHERE id = :id");
            MapSqlParameterSource[] mapSqlParameterSources = new MapSqlParameterSource[revokeCerts.size()];
            MapSqlParameterSource mapSqlParameterSource = null;
            for (int i = 0; i < revokeCerts.size(); ++i) {
                CertDO certDO = revokeCerts.get(i);
                mapSqlParameterSource = new MapSqlParameterSource();
                mapSqlParameterSource.addValue("id", (Object)certDO.getId());
                mapSqlParameterSource.addValue("revokeRease", (Object)revokeRease);
                mapSqlParameterSource.addValue("gmCreate", (Object)revokeDate);
                mapSqlParameterSource.addValue("keyRevokeStatus", (Object)keyRevokeStatus);
                if (StringUtils.isNotBlank((CharSequence)revokeNote)) {
                    mapSqlParameterSource.addValue("revokeNote", (Object)revokeNote);
                }
                mapSqlParameterSources[i] = mapSqlParameterSource;
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])mapSqlParameterSources);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u51bb\u7ed3\u72b6\u6001\u7684\u8bc1\u4e66\u4e3a\u64a4\u9500\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void delete(String signSn, String encSn) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            MapSqlParameterSource params = new MapSqlParameterSource();
            stringBuffer.append("DELETE FROM revoked_cert WHERE sn=:signSn ");
            if (StringUtils.isNotBlank((CharSequence)encSn)) {
                stringBuffer.append("OR sn=:encSn ");
                params.addValue("encSn", (Object)encSn);
            }
            params.addValue("signSn", (Object)signSn);
            this.daoTemplate.executeSql(stringBuffer.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> queryCrlCertList(Integer baseAlgType, Date thisUpdateTime, Long crlTempId, Integer segmentNo) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM revoked_cert ").append("WHERE  public_key_alg = :alg AND segment_no=:segmentNo AND crl_temp_id=:crlTempId  AND after_time >= now() AND gmt_create <= :thisUpdateTime ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)baseAlgType);
            parameterSource.addValue("thisUpdateTime", (Object)thisUpdateTime);
            parameterSource.addValue("segmentNo", (Object)segmentNo);
            parameterSource.addValue("crlTempId", (Object)crlTempId);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1CRL\u6240\u9700\u7684\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateCrlTempIdAndSegmentNo(String sn, long crlTempId, int segmentNo) {
        try {
            String sql = "DELETE FROM revoked_cert WHERE sn=:sn OR pair_cert_sn=:sn";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("sn", (Object)sn);
            this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u64a4\u9500\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<RevokedCertDO> getCertsByTemplateId(long templateId) {
        try {
            Cnd cnd = Cnd.where((String)"template_id", (String)"=", (Object)templateId).and("crl_temp_id", "=", null);
            return this.daoTemplate.query(RevokedCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u627e\u67d0\u8bc1\u4e66\u6a21\u677f\u5bf9\u5e94\u7684\u7528\u6237\u8bc1\u4e66", (Throwable)e);
        }
    }

    public void updateCertCrlTempIdAndSegmentNo(long certId, long crlTempId, int segmentNo) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE revoked_cert SET crl_temp_id=:crlTempId ,segment_no =:segmentNo where id=:certId");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("crlTempId", (Object)crlTempId);
            params.addValue("segmentNo", (Object)segmentNo);
            params.addValue("certId", (Object)certId);
            this.daoTemplate.executeSql(sqlBuffer.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

