/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.SubCaDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SubCaManageDao
extends BaseJdbcDao {
    public PageInfo getSubCaManageList(Map<String, Object> param, Pager pager) {
        try {
            PageInfo pageInfo = new PageInfo();
            int pageNumber = pager.getPageNumber();
            int pageSize = pager.getPageSize();
            pageInfo.setPageNo(pageNumber);
            pageInfo.setPageSize(pageSize);
            String name = (String)param.get("name");
            Cnd cnd = Cnd.where((String)"1", (String)"=", (Object)"1");
            if (!StringUtils.isBlank((CharSequence)name)) {
                cnd.and("name", "like", (Object)("%" + name + "%"));
            }
            pageInfo.setRecordCount(this.daoTemplate.count(SubCaDO.class, (Condition)cnd));
            cnd.orderBy("gmtCreate", "desc");
            List subCaList = this.daoTemplate.query(SubCaDO.class, (Condition)cnd, pager);
            pageInfo.setDatas((Collection)subCaList);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u4e0b\u7ea7CA\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveSubCa(SubCaDO subCa) {
        try {
            this.daoTemplate.insert((Object)subCa);
        }
        catch (Exception e) {
            throw new DAOException("\u65b0\u589e\u4e0b\u7ea7CA\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateSubCa(SubCaDO subCa) {
        try {
            this.daoTemplate.updateIgnoreNull((Object)subCa);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u4e0b\u7ea7CA\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public SubCaDO getSubCa(long id) {
        try {
            return (SubCaDO)this.daoTemplate.fetch(SubCaDO.class, id);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u4e0b\u7ea7CA\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getCaNameUnique(String name, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM sub_ca WHERE organization_name = :name ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("name", (Object)name);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u4e0b\u7ea7CA\u7684name\u662f\u5426\u91cd\u590d\u5f02\u5e38", (Throwable)e);
        }
    }
}

