/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CrlExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlTemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlTemplateExtensionDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CrlTemplateDao
extends BaseJdbcDao {
    public boolean checkCrlTemplateNameExist(String name) {
        Cnd cnd = Cnd.where((String)"crl_temp_name", (String)"=", (Object)name);
        return this.daoTemplate.count(CrlTemplateDO.class, (Condition)cnd) > 0;
    }

    public void saveCrlTemplate(CrlTemplateDO crlTemplateDO) {
        try {
            this.daoTemplate.insert((Object)crlTemplateDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58crl\u6a21\u677f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CrlTemplateDO getCrlTemplateById(Long id) {
        try {
            return (CrlTemplateDO)this.daoTemplate.fetch(CrlTemplateDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u67e5\u8be2crl\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Long> getExtensionIdByOID(List<String> oids) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            List extensions = this.daoTemplate.query(CrlExtensionDO.class, (Condition)Cnd.where((String)"exten_oid", (String)"IN", oids));
            for (CrlExtensionDO item : extensions) {
                result.put(item.getExtenOid(), item.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eOID\u5217\u8868\u83b7\u53d6\u6570\u636e\u5e93ID\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<Long, String> getExtensionOIDByID(List<Long> ids) {
        try {
            HashMap<Long, String> result = new HashMap<Long, String>();
            List extensions = this.daoTemplate.query(CrlExtensionDO.class, (Condition)Cnd.where((String)"id", (String)"IN", ids));
            for (CrlExtensionDO item : extensions) {
                result.put(item.getId(), item.getExtenOid());
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u5217\u8868\u83b7\u53d6\u6570\u636e\u5e93OID\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteExtensionByCrlTempId(Long id) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource("crl_temp_id", (Object)id);
            this.daoTemplate.deleteBySql("DELETE FROM crl_template_extension WHERE crl_temp_id = :crl_temp_id", (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664crl\u6a21\u677f\u6269\u5c55\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteCrlTemplate(Long id) {
        try {
            this.daoTemplate.delete(CrlTemplateDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664crl\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveCrlTemplateExtensions(List<CrlTemplateExtensionDO> list) {
        try {
            this.daoTemplate.insert(list);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u6a21\u677f\u6269\u5c55\u9879\u5173\u7cfb\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo queryCrlTemplates(CrlTemplateDO query, int pageNo, int pageSize) {
        Cnd cnd = Cnd.where((String)"1", (String)"=", (Object)1);
        if (StringUtils.isNotBlank((CharSequence)query.getCrlTempName())) {
            cnd.and("crl_temp_name", "LIKE", (Object)("%" + query.getCrlTempName() + "%"));
        }
        if (null != query.getCrlStatus()) {
            cnd.and("crl_status", "=", (Object)query.getCrlStatus());
        }
        if (null != query.getCrlSignAlg()) {
            cnd.and("crl_sign_alg", "=", (Object)query.getCrlSignAlg());
        }
        cnd.orderBy("gmt_create", "desc");
        try {
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(CrlTemplateDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(CrlTemplateDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2crl\u6a21\u677f\u4fe1\u606f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlTemplateExtensionDO> queryTemplateExtensionByCrlTemplateId(Long crlTemplateId) {
        try {
            Cnd cnd = Cnd.where((String)"crl_temp_id", (String)"=", (Object)crlTemplateId);
            return this.daoTemplate.query(CrlTemplateExtensionDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2crl\u6a21\u677f\u6269\u5c55\u4fe1\u606f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Integer getCrlTemplateStatus(Long id) {
        String sql = "select crl_status from crl_template where id = :id";
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)new MapSqlParameterSource("id", (Object)id));
    }

    public Integer getCrlTemplateCertCount(Long id) {
        String sql = "select cert_count from crl_template where id = :id";
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)new MapSqlParameterSource("id", (Object)id));
    }
}

