/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CrossCertDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CrossCertDao
extends BaseJdbcDao {
    public CrossCertDO getCrossCert(String sn, int keyAlg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg);
            return (CrossCertDO)this.daoTemplate.fetch(CrossCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5e8f\u5217\u53f7\u3001\u5bc6\u94a5\u7b97\u6cd5\u83b7\u53d6\u4ea4\u53c9\u8bc1\u4e66\u539f\u6587\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateCrossCert(CrossCertDO crossCertDO) {
        try {
            return this.update(crossCertDO);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u4ea4\u53c9\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<Long, String> getCrossCertData(List<Long> ids) {
        try {
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            final HashMap<Long, String> result = new HashMap<Long, String>();
            String sql = "SELECT id, data FROM cross_cert WHERE id IN (:ids)";
            this.daoTemplate.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("ids", ids), (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowId) throws SQLException {
                    do {
                        result.put(rs.getLong("id"), rs.getString("data"));
                    } while (rs.next());
                    return null;
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66Id\u5217\u8868\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u539f\u6587\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CrossCertDO save(CrossCertDO crossCertDO) {
        try {
            return (CrossCertDO)this.daoTemplate.insert((Object)crossCertDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u4ea4\u53c9\u8bc1\u4e66\u5230\u6570\u636e\u5e93\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo getCrossCertList(Map<String, Object> param, Pager pager) {
        try {
            PageInfo pageInfo = new PageInfo();
            int pageNumber = pager.getPageNumber();
            int pageSize = pager.getPageSize();
            pageInfo.setPageNo(pageNumber);
            pageInfo.setPageSize(pageSize);
            String certDn = (String)param.get("certDn");
            Cnd cnd = Cnd.where((String)"1", (String)"=", (Object)"1");
            if (!StringUtils.isBlank((CharSequence)certDn)) {
                cnd.and("subject", "like", (Object)("%" + certDn + "%"));
            }
            pageInfo.setRecordCount(this.daoTemplate.count(CrossCertDO.class, (Condition)cnd));
            cnd.orderBy("beforeTime", "desc");
            List subCaCertList = this.daoTemplate.query(CrossCertDO.class, (Condition)cnd, pager);
            pageInfo.setDatas((Collection)subCaCertList);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

