/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CustomizeExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateCustomizeExtensionDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.securitymanager.service.vo.TemplateCustomizeExtensionDTO;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomizeExtenDao
extends BaseJdbcDao {
    public PageInfo queryCustomizeExten(CustomizeExtensionDO query, int pageNo, int pageSize) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotBlank((CharSequence)query.getCustomizeExtenOid())) {
            cnd.and("customize_exten_oid", "like", (Object)("%" + query.getCustomizeExtenOid() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCustomizeExtenName())) {
            cnd.and("customize_exten_name", "like", (Object)("%" + query.getCustomizeExtenName() + "%"));
        }
        if (null != query.getEncodeType()) {
            cnd.and("encode_type", "=", (Object)query.getEncodeType());
        }
        if (null != query.getUseStatus()) {
            cnd.and("use_status", "=", (Object)query.getUseStatus());
        }
        cnd.orderBy("gmt_create", "desc");
        try {
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(CustomizeExtensionDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(CustomizeExtensionDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5217\u8868\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5f02\u5e38", (Throwable)e);
        }
    }

    public CustomizeExtensionDO getCustomizeExtenInfo(long id) {
        try {
            return (CustomizeExtensionDO)this.daoTemplate.fetch(CustomizeExtensionDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u8be6\u60c5\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveCustomizeExtenInfo(CustomizeExtensionDO customizeExtensionDO) {
        try {
            this.daoTemplate.insert((Object)customizeExtensionDO);
        }
        catch (Exception e) {
            throw new DAOException("\u65b0\u589e\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateCustomizeExtenInfo(CustomizeExtensionDO customizeExtensionDO) {
        try {
            this.daoTemplate.updateIgnoreNull((Object)customizeExtensionDO);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int verifyNameUnique(String name, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM customize_extension WHERE customize_exten_name = :name AND use_status != 2 ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("name", (Object)name);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u7684name\u662f\u5426\u91cd\u590d\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int verifyNameExtension(String name) {
        try {
            String sql = "SELECT COUNT(*) FROM extension  WHERE name = :name ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("name", (Object)name);
            return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u7684name\u662f\u5426\u91cd\u590d\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int verifyOidUnique(String oid, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM customize_extension WHERE customize_exten_oid = :oid AND use_status != 2 ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("oid", (Object)oid);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u7684Oid\u662f\u5426\u91cd\u590d\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int verifyOidExtension(String oid) {
        try {
            String sql = "SELECT COUNT(*) FROM extension  WHERE extn_id = :oid ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("oid", (Object)oid);
            return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u7684Oid\u662f\u5426\u91cd\u590d\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateCustomizeExtenStatus(long id, int useStatus) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE customize_extension SET use_status = :use_status WHERE id = :id ;");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("id", (Object)id);
            params.addValue("use_status", (Object)useStatus);
            return this.daoTemplate.update(sql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteCustomizeExtenInfo(long id) {
        try {
            this.daoTemplate.delete(CustomizeExtensionDO.class, id);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u65b0\u589e\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getCustomizeExtenStatusByExtenId(long custonizeExtenId) {
        try {
            String sql = "SELECT use_status FROM customize_extension WHERE id = :id ;";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("id", (Object)custonizeExtenId);
            return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7684\u72b6\u6001\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CustomizeExtensionDO> queryCustonizeExten() {
        try {
            String sql = "SELECT * FROM customize_extension WHERE use_status != 2;";
            return this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(CustomizeExtensionDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u4e0d\u5206\u9875\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveTempAndCustomizeExten(List<TemplateCustomizeExtensionDO> templateCustomizeExtensionDOs) {
        try {
            this.daoTemplate.insert(templateCustomizeExtensionDOs);
        }
        catch (Exception e) {
            throw new DAOException("\u65b0\u589e\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<TemplateCustomizeExtensionDTO> getCertCustomizeExtenInfo(long tempId) {
        try {
            String sql = "SELECT a.template_id AS templateId, a.customize_exten_id AS customizeExtenId, a.is_request AS isRequest, a.is_critical AS isCritical, a.is_client AS isClient,a.value AS value,b.customize_exten_name AS customizeExtenName, b.customize_exten_oid AS customizeExtenOid ,b.encode_type AS encodeType FROM template_customize_extension AS a, customize_extension AS b WHERE a.template_id = :tempId AND a.customize_exten_id = b.id;";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("tempId", (Object)tempId);
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(TemplateCustomizeExtensionDTO.class));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6a21\u677f\u5bf9\u5e94\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u8054\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteCertCustomizeExtenInfo(long tempId) {
        try {
            String sql = "DELETE FROM template_customize_extension WHERE template_id = :tempId ;";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("tempId", (Object)tempId);
            this.daoTemplate.deleteBySql(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u65b0\u589e\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CustomizeExtensionDO> getAllUsedCustomizeExten() {
        try {
            String sql = "SELECT * FROM customize_extension WHERE use_status!=0;";
            return this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(CustomizeExtensionDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6240\u6709\u5df2\u4f7f\u7528\u8fc7\u7684\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5f02\u5e38", (Throwable)e);
        }
    }
}

