/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CrlBeanDo;
import com.xdja.pki.ca.certmanager.dao.models.DeltaRevokedCertDO;
import com.xdja.pki.ca.core.ca.util.gm.cert.CrlUtil;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.gmssl.x509.utils.bean.CRLEntry;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeltaRevokeCertDao
extends BaseJdbcDao {
    public void saveBatch(List<DeltaRevokedCertDO> certs) {
        try {
            this.daoTemplate.insert(certs);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58\u64a4\u9500\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void delete(String sn) {
        try {
            String sql = "DELETE FROM delta_revoked_cert WHERE sn=:sn";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("sn", (Object)sn);
            this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u589e\u91cf\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void delete(String signSn, String encSn) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            MapSqlParameterSource params = new MapSqlParameterSource();
            stringBuffer.append("DELETE FROM delta_revoked_cert WHERE sn=:signSn ");
            if (StringUtils.isNotBlank((CharSequence)encSn)) {
                stringBuffer.append("OR sn=:encSn ");
                params.addValue("encSn", (Object)encSn);
            }
            params.addValue("signSn", (Object)signSn);
            this.daoTemplate.executeSql(stringBuffer.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u589e\u91cf\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CRLEntry> queryDeltaCRLInfo(String alg) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM delta_revoked_cert ").append("WHERE key_alg = :alg ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)alg);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CRLEntry.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u6700\u65b0\u7684CRL\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CRLEntry> queryDeltaCRLInfo(String beginSn, String endSn, String alg) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM delta_revoked_cert ").append("WHERE sn >= :beginSn AND sn <= :endSn AND key_alg = :alg ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("beginSn", (Object)beginSn);
            parameterSource.addValue("endSn", (Object)endSn);
            parameterSource.addValue("alg", (Object)alg);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CRLEntry.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u6709\u5206\u7247\u7684\u589e\u91cfCRL\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void save(DeltaRevokedCertDO signSnDo) {
        try {
            this.daoTemplate.insert((Object)signSnDo);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteBatch(Map<Integer, X509CRL> x509CRLS, Integer alg) {
        try {
            String sql = "DELETE FROM delta_revoked_cert WHERE sn = :sn AND key_alg = :keyAlg";
            ArrayList<MapSqlParameterSource> parameterSources = new ArrayList<MapSqlParameterSource>();
            for (Integer integer : x509CRLS.keySet()) {
                X509CRL x509CRL = x509CRLS.get(integer);
                List list = CrlUtil.getRevokeCertSnList((X509CRL)x509CRL);
                if (null == list) continue;
                for (Object o : list) {
                    MapSqlParameterSource parameter = new MapSqlParameterSource();
                    parameter.addValue("sn", (Object)o.toString());
                    parameter.addValue("keyAlg", (Object)alg);
                    parameterSources.add(parameter);
                }
            }
            if (parameterSources.size() == 0) {
                return;
            }
            this.daoTemplate.batch(sql, (SqlParameterSource[])parameterSources.toArray(new MapSqlParameterSource[parameterSources.size()]));
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4ece\u589e\u91cfCRL\u4fe1\u606f\u4e2d\u5220\u9664\u5185\u5bb9\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForCrl(String tmpLastMaxSn, String tmpUpdateMaxSn, Integer alg, Date thisUpdateDate) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM delta_revoked_cert ").append("WHERE sn >= :tmpLastMaxSn AND sn <= :tmpUpdateMaxSn AND key_alg = :alg ").append("AND gmt_create <= :time");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("tmpLastMaxSn", (Object)tmpLastMaxSn);
            parameterSource.addValue("tmpUpdateMaxSn", (Object)tmpUpdateMaxSn);
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u4ece\u589e\u91cfCR\u4e2d\u83b7\u53d6\u5206\u7247\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> getSnsForDrl(Integer alg, Date thisUpdateDate, int begin, int end) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM delta_revoked_cert ").append("WHERE key_alg = :alg ").append("AND gmt_create <= :time ").append("order by id limit ").append(begin + "," + end + " ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)alg);
            parameterSource.addValue("time", (Object)thisUpdateDate);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1DRL\u6240\u9700\u7684\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CrlBeanDo> queryDrlCertList(Integer baseAlgType, Date thisUpdateTime, Long crlTempId, int segmentNo) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT sn userCertificateSerial, revoke_reason reason, gmt_create revocationDate FROM delta_revoked_cert ").append("WHERE key_alg = :alg ").append("AND gmt_create <= :time ").append("and crl_temp_id = :crlTempId ").append("AND segment_no = :segmentNo");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("alg", (Object)baseAlgType);
            parameterSource.addValue("time", (Object)thisUpdateTime);
            parameterSource.addValue("segmentNo", (Object)segmentNo);
            parameterSource.addValue("crlTempId", (Object)crlTempId);
            return this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CrlBeanDo.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7b7e\u53d1DRL\u6240\u9700\u7684\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

