/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.RaAdminCertDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RaAdminCertDao
extends BaseJdbcDao {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public RaAdminCertDO save(RaAdminCertDO raAdminCertDO) {
        try {
            return (RaAdminCertDO)this.daoTemplate.insert((Object)raAdminCertDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58RA\u7ba1\u7406\u5458\u8bc1\u4e66\u6620\u5c04\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updatePriCertStatus(String signSn, String encSn) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE manage_cert SET confirmation_status = :status, gmt_modified = :modifyTime ").append("WHERE (sn = :signSn AND pair_cert_sn = :encSn) ").append("OR (sn = :encSn AND pair_cert_sn = :signSn) ").append("AND confirmation_status = :srcStatus");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("status", (Object)Constants.ISSUE_CERT_OK_ACK);
            parameterSource.addValue("srcStatus", (Object)Constants.ISSUE_CERT_NO_ACK);
            parameterSource.addValue("signSn", (Object)signSn);
            parameterSource.addValue("encSn", (Object)encSn);
            parameterSource.addValue("modifyTime", (Object)new Date());
            return this.update(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateRaAdminCert(String sn, Long oldSignCertId, Long signCertId, Date notBefore) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("UPDATE ra_admin_cert SET manage_cert_id =:managerCertId, ").append("gmt_modified =:modifyTime ").append("WHERE manage_cert_id =:oldmanagerCertId ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("managerCertId", (Object)signCertId);
            parameterSource.addValue("modifyTime", (Object)notBefore);
            parameterSource.addValue("oldmanagerCertId", (Object)oldSignCertId);
            this.daoTemplate.executeSql(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u7ba1\u7406\u5458\u8bc1\u4e66\u5173\u7cfb\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo getRACertLists(Map<String, Object> param, Pager pager) {
        Integer certType;
        StringBuffer sqlBuffer = new StringBuffer();
        String raAdminCertSelect = "(SELECT server.ra_id, 3 as role_type, server.manage_cert_id FROM ra_server_cert server union all SELECT admin.ra_id,admin.role_type,admin.manage_cert_id FROM ra_admin_cert admin) admincert";
        String selectColumns = " ra.id,ra.name,managecert.subject,managecert.sn,managecert.pair_cert_sn, managecert.status,admincert.role_type, managecert.before_time, managecert.after_time ";
        String selectColumnsCount = "count(*)";
        sqlBuffer.append("select " + selectColumns + " from " + raAdminCertSelect + " join ra ra on admincert.ra_id=ra.id join ");
        String raManageCerttable = "manage_cert managecert on managecert.type = 1 and admincert.manage_cert_id = managecert.id";
        String raRevokeManageCerttable = "(select *, 3 as status from revoked_manage_cert) managecert on managecert.type = 1 and admincert.manage_cert_id = managecert.id";
        String raOutDateManageCerttable = "(select m.id,m.type,m.subject,m.sn,m.pair_cert_sn,m.before_time, m.after_time,4 as status from manage_cert m where m.after_time< now() union all select r.id,r.type,r.subject,r.sn,r.pair_cert_sn,r.before_time, r.after_time,4 as status from revoked_manage_cert r where r.after_time< now() union all select id,type,subject,sn,pair_cert_sn, before_time, after_time, 4 as status from outdate_manage_cert) managecert on managecert.type = 1 and admincert.manage_cert_id = managecert.id";
        Integer status = (Integer)param.get("status");
        String aftertimeselct = " and managecert.after_time > now()";
        String confirmStatusselect = " and managecert.confirmation_status=" + Constants.ISSUE_CERT_OK_ACK;
        switch (status) {
            case 3: {
                sqlBuffer.append(raRevokeManageCerttable);
                sqlBuffer.append(aftertimeselct);
                break;
            }
            case 4: {
                sqlBuffer.append(raOutDateManageCerttable);
                break;
            }
            default: {
                sqlBuffer.append(raManageCerttable);
                sqlBuffer.append(aftertimeselct);
                sqlBuffer.append(confirmStatusselect);
            }
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("name")))) {
            String nameselet = " and ra.name like '%" + (String)param.get("name") + "%'";
            sqlBuffer.append(nameselet);
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("certDN")))) {
            String certDNselect = " and managecert.subject like '%" + (String)param.get("certDN") + "%'";
            sqlBuffer.append(certDNselect);
        }
        if (null != (Integer)param.get("certType") && ((certType = (Integer)param.get("certType")) == 1 || certType == 2 || certType == 3 || certType == 4)) {
            String certTypeselect = " and admincert.role_type = " + certType;
            sqlBuffer.append(certTypeselect);
        }
        sqlBuffer.append(" and managecert.status = " + status);
        try {
            String sqlcount = sqlBuffer.toString().replaceFirst(selectColumns, selectColumnsCount);
            pager.setRecordCount(this.daoTemplate.queryForInt(sqlcount, null));
            this.logger.debug(sqlBuffer.toString());
            sqlBuffer.append(" order by managecert.before_time desc");
            int pageNumber = pager.getPageNumber();
            int pageSize = pager.getPageSize();
            int offset = pager.getOffset();
            sqlBuffer.append(" limit " + offset + ", " + pageSize);
            List raCertList = this.daoTemplate.queryForList(sqlBuffer.toString(), null);
            this.logger.debug(sqlBuffer.toString());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setPageNo(pageNumber);
            pageInfo.setPageSize(pageSize);
            pageInfo.setRecordCount(pager.getRecordCount());
            pageInfo.setDatas((Collection)raCertList);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u8bc1\u4e66\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public RaAdminCertDO getRaAdminCertByManageId(Long managerCertId) {
        try {
            return (RaAdminCertDO)this.daoTemplate.fetch(RaAdminCertDO.class, (Condition)Cnd.where((String)"manageCertId", (String)"=", (Object)managerCertId));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636emanagerCertId\u67e5\u8be2RA\u7ba1\u7406\u5458\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

