/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.ArchiveCertDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.util.cri.SqlExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArchiveCertDao
extends BaseJdbcDao {
    private static final Logger log = LoggerFactory.getLogger(ArchiveCertDao.class);

    public Result saveBatch(List<ArchiveCertDO> certList) {
        log.info("[ArchiveCertDao#saveBatch] out date cert batch save in archive cert");
        try {
            StringBuffer sqlBuffer = new StringBuffer(512);
            sqlBuffer.append("INSERT INTO `archive_cert`(`id`,`ca_cert_id`,`sn`,`subject`,`issuer`,`public_key_alg`,").append("`private_key_size`,`before_time`,`after_time`,`sign_alg`,`type`,`template_id`,").append("`is_revoke_key`,`pair_cert_id`,`pair_cert_sn`,`status`,`old_cert_id`,`key_revoked_status`,").append("`key_not_before_time`,`key_not_after_time`,`revoke_reason`,`revoke_note`,`confirmation_status`,").append("`frozen_num`,`gmt_create`,`gmt_modified`)").append(" VALUES (:id,:caCertId,:sn,:subject,:issuer,:publicKeyAlg,:privateKeySize,:beforeTime,").append(":afterTime,:signAlg,:type,:templateId,:isRevokeKey,:pairCertId,:pairCertSn,:status,:oldCertId,").append(":keyRevokedStatus,:keyNotBeforeTime,:keyNotAfterTime,:revokeReason,:revokeNote,").append(":confirmationStatus,:frozenNum,:gmtCreate,:gmtModified)");
            SqlParameterSource[] sqlParameterSources = new SqlParameterSource[certList.size()];
            for (int i = 0; i < certList.size(); ++i) {
                sqlParameterSources[i] = new BeanPropertySqlParameterSource((Object)certList.get(i));
            }
            this.daoTemplate.batch(sqlBuffer.toString(), sqlParameterSources);
            return Result.success();
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u5f52\u6863\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public PageInfo queryArchiveCertList(ArchiveCertDO query, Long caId, int pageNo, int pageSize) {
        Cnd cnd = null != query.getSn() ? Cnd.where((SqlExpression)Cnd.exps((String)"sn", (String)"like", (Object)("%" + query.getSn() + "%")).orLike("pair_cert_sn", query.getSn())) : Cnd.NEW();
        if (StringUtils.isNotBlank((CharSequence)query.getSubject())) {
            cnd.where().andLike("subject", query.getSubject());
        }
        if (null != caId) {
            cnd.where().andInBySql("template_id", "SELECT id AS template_id FROM template WHERE ca_id='%s'", new Object[]{caId});
        }
        cnd.where().andLTE("type", 2L);
        cnd.getOrderBy().desc("gmt_create");
        try {
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(ArchiveCertDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(ArchiveCertDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2\u5f52\u6863\u8bc1\u4e66\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ArchiveCertDO getArchiveCertById(Long id) {
        try {
            Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
            return (ArchiveCertDO)this.daoTemplate.fetch(ArchiveCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66id\u83b7\u53d6\u5f52\u6863\u8bc1\u4e66\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ArchiveCertDO getArchiveCertBySn(String signSn) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)signSn);
            return (ArchiveCertDO)this.daoTemplate.fetch(ArchiveCertDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66SN\u548c\u5bc6\u94a5\u7b97\u6cd5\u83b7\u53d6\u5f52\u6863\u8bc1\u4e66\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int deleteArchiveCertById(Long id) {
        try {
            return this.daoTemplate.delete(ArchiveCertDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66id\u5220\u9664\u5f52\u6863\u8bc1\u4e66", (Throwable)e);
        }
    }
}

