/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.pager.Pager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CaAdminCertDao
extends BaseJdbcDao {
    @Autowired
    private Environment environment;

    public PageInfo getCaAdminCertLists(Map<String, Object> param, Pager pager) {
        int dbType = Integer.valueOf(this.environment.getProperty("system.database.type"));
        Object timeObject = DateTimeUtil.getTimeObject((int)dbType);
        Integer caManageRoleType = (Integer)param.get("caManageRoleType");
        StringBuffer sqlBuffer = new StringBuffer();
        String caAdminManageSelect = "(select adminrole.manage_cert_id,role.type FROM admin_role adminrole join role on adminrole.role_id=role.id and role.type=:caManageRoleType) adminmanage";
        String selectColumns = " adminmanage.type, managecert.subject,managecert.sn,managecert.pair_cert_sn,managecert.sign_alg, managecert.status,managecert.before_time, managecert.after_time ";
        String selectColumnsCount = "count(*)";
        sqlBuffer.append("select " + selectColumns + " from " + caAdminManageSelect + " join ");
        String caManageCerttable = "manage_cert managecert ";
        String caRevokeManageCerttable = "(select *, 3 as status from revoked_manage_cert) managecert ";
        String caOutDateManageCerttable = "(select m.id,m.type,m.subject,m.sn,m.pair_cert_sn,m.before_time, m.after_time,m.sign_alg,4 as status from manage_cert m where m.after_time< '" + timeObject.toString() + "' union all select r.id,r.type,r.subject,r.sn,r.pair_cert_sn,r.before_time, r.after_time, r.sign_alg, 4 as status from revoked_manage_cert r where r.after_time<  '" + timeObject.toString() + "' union all select id,type,subject,sn,pair_cert_sn, before_time, after_time,sign_alg, 4 as status from outdate_manage_cert)  managecert";
        String caManageCertJoinStr = " on managecert.type = 1 and adminmanage.manage_cert_id = managecert.id";
        Integer status = (Integer)param.get("status");
        String aftertimeselct = " and managecert.after_time > '" + timeObject.toString() + "' ";
        String confirmStatusselect = " and managecert.confirmation_status=" + Constants.ISSUE_CERT_OK_ACK;
        switch (status) {
            case 3: {
                sqlBuffer.append(caRevokeManageCerttable);
                sqlBuffer.append(caManageCertJoinStr);
                sqlBuffer.append(aftertimeselct);
                break;
            }
            case 4: {
                sqlBuffer.append(caOutDateManageCerttable);
                sqlBuffer.append(caManageCertJoinStr);
                break;
            }
            default: {
                sqlBuffer.append(caManageCerttable);
                sqlBuffer.append(caManageCertJoinStr);
                sqlBuffer.append(aftertimeselct);
                sqlBuffer.append(confirmStatusselect);
            }
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("certDn")))) {
            String certDNselect = " and managecert.subject like :certDn";
            sqlBuffer.append(certDNselect);
        }
        if (!StringUtils.isBlank((CharSequence)((String)param.get("sn")))) {
            String snSelect = " and (managecert.sn like :sn or managecert.pair_cert_sn like :sn)";
            sqlBuffer.append(snSelect);
        }
        sqlBuffer.append(" and managecert.status = :status");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)("%" + (String)param.get("certDn") + "%"));
        params.addValue("status", (Object)status);
        params.addValue("sn", (Object)("%" + (String)param.get("sn") + "%"));
        params.addValue("caManageRoleType", (Object)caManageRoleType);
        try {
            String sqlcount = sqlBuffer.toString().replaceFirst(selectColumns, selectColumnsCount);
            pager.setRecordCount(this.daoTemplate.queryForInt(sqlcount, (SqlParameterSource)params));
            this.logger.debug("================" + sqlBuffer.toString());
            sqlBuffer.append(" order by managecert.before_time desc");
            int pageNumber = pager.getPageNumber();
            int pageSize = pager.getPageSize();
            int offset = pager.getOffset();
            sqlBuffer.append(" limit " + offset + ", " + pageSize);
            List raCertList = this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)params);
            this.logger.debug(sqlBuffer.toString());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setPageNo(pageNumber);
            pageInfo.setPageSize(pageSize);
            pageInfo.setRecordCount(pager.getRecordCount());
            pageInfo.setDatas((Collection)raCertList);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

