/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.CrlDO;
import com.xdja.pki.ca.certmanager.dao.models.DeltaCrlDO;
import com.xdja.pki.ca.core.ca.util.gm.cert.CrlUtil;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CrlDao
extends BaseJdbcDao {
    public Map<String, Long> saveCrls(Long caCertId, Long crlTempId, Map<Integer, X509CRL> x509CRLS) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            for (Integer integer : x509CRLS.keySet()) {
                X509CRL x509CRL = x509CRLS.get(integer);
                CrlDO crlDO = new CrlDO();
                crlDO.setCaCertId(caCertId);
                String crlName = (crlTempId == 0L ? "" : crlTempId) + "crl" + integer + ".crl";
                crlDO.setName(crlName);
                crlDO.setCrlTempId(crlTempId);
                crlDO.setSn(CrlUtil.getSnByX509Crl((X509CRL)x509CRL).toString(16));
                crlDO.setThisUpdateTime(x509CRL.getThisUpdate());
                crlDO.setNextUpdateTime(x509CRL.getNextUpdate());
                crlDO.setGmtCreate(new Date());
                crlDO = (CrlDO)this.daoTemplate.insert((Object)crlDO);
                result.put(crlDO.getSn(), crlDO.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58CRL\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public Date getCrlLastUpdateTime() {
        try {
            Condition cnd = Cnd.wrap((String)"id=(select MAX(id) from crl )");
            CrlDO crlDO = (CrlDO)this.daoTemplate.fetch(CrlDO.class, cnd);
            if (null == crlDO) {
                return null;
            }
            return crlDO.getNextUpdateTime();
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u83b7\u53d6\u6700\u65b0CRL\u7684\u66f4\u65b0\u65f6\u95f4\u6765\u5224\u65ad\u662f\u5426\u7b7e\u53d1\u8fc7CRL\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getArlLastUpdateTime() {
        try {
            Condition cnd = Cnd.wrap((String)"id=(select MAX(id) from delta_crl )");
            DeltaCrlDO deltaCrlDO = (DeltaCrlDO)this.daoTemplate.fetch(DeltaCrlDO.class, cnd);
            if (null == deltaCrlDO) {
                return null;
            }
            return deltaCrlDO.getNextUpdateTime();
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u83b7\u53d6\u6700\u65b0ARL\u7684\u66f4\u65b0\u65f6\u95f4\u6765\u5224\u65ad\u662f\u5426\u7b7e\u53d1\u8fc7ARL\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Long> saveDrls(Long caCertId, Map<Integer, X509CRL> x509CRLMap, Map<String, Object> drlIdData, Long crlTempId) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            for (Integer i : x509CRLMap.keySet()) {
                X509CRL x509CRL = x509CRLMap.get(i);
                DeltaCrlDO deltaCrlDO = new DeltaCrlDO();
                deltaCrlDO.setCaCertId(caCertId);
                String crlName = (crlTempId == 0L ? "" : crlTempId) + "drl" + i + ".crl";
                Long crlId = (Long)drlIdData.get((crlTempId == 0L ? "" : crlTempId) + "crl" + i + ".crl");
                if (null == crlId) continue;
                deltaCrlDO.setCrlId(crlId);
                deltaCrlDO.setName(crlName);
                deltaCrlDO.setCrlTempId(crlTempId);
                deltaCrlDO.setSn(CrlUtil.getSnByX509Crl((X509CRL)x509CRL).toString(16));
                deltaCrlDO.setThisUpdateTime(x509CRL.getThisUpdate());
                deltaCrlDO.setNextUpdateTime(x509CRL.getNextUpdate());
                deltaCrlDO.setGmtCreate(new Date());
                deltaCrlDO = (DeltaCrlDO)this.daoTemplate.insert((Object)deltaCrlDO);
                result.put(deltaCrlDO.getSn(), deltaCrlDO.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58CRL\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> getLastCrlId(Long crlTempId) {
        try {
            String sql = "SELECT id, name FROM crl WHERE crl_temp_id=:crlTempId and  this_update_time = (SELECT max(this_update_time) FROM crl where  crl_temp_id=:crlTempId)";
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("crlTempId", (Object)crlTempId);
            parameterSource.addValue("crlTempId", (Object)crlTempId);
            List list = this.daoTemplate.queryForList(sql, (SqlParameterSource)parameterSource);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                resultMap.put(item.get("name").toString(), item.get("id"));
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6700\u65b0\u7684CRL\u7684ID\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public String getLastCrlSn(String crlName) {
        try {
            String sql = "id=(select MAX(id) from crl where name = '" + crlName + "')";
            Condition cnd = Cnd.wrap((String)sql);
            CrlDO crlDO = (CrlDO)this.daoTemplate.fetch(CrlDO.class, cnd);
            if (null == crlDO) {
                return "";
            }
            return crlDO.getSn();
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u5e03\u589e\u91cfCRL\u83b7\u53d6baseCRL\u7684SN\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684baseCRL\uff0cbaseCRL=" + crlName, (Throwable)e);
            throw new DAOException("\u6839\u636ecrl\u540d\u79f0\u83b7\u53d6CRL\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public String getLastCrlSnById(Long id) {
        try {
            CrlDO crlDO = (CrlDO)this.daoTemplate.fetch(CrlDO.class, id.longValue());
            if (null == crlDO) {
                return "";
            }
            return crlDO.getSn();
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eId\u83b7\u53d6CRL\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Date getCrlLastNextUpdatTimeByCrlTemplateId(Long tempId) {
        try {
            Condition cnd = Cnd.wrap((String)("id=(select MAX(id) from crl where crl_temp_id=" + tempId + ")"));
            CrlDO crlDO = (CrlDO)this.daoTemplate.fetch(CrlDO.class, cnd);
            if (null == crlDO) {
                return null;
            }
            return crlDO.getNextUpdateTime();
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u83b7\u53d6\u6700\u65b0CRL\u7684\u66f4\u65b0\u65f6\u95f4\u6765\u5224\u65ad\u662f\u5426\u7b7e\u53d1\u8fc7CRL\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getDrlLastNextUpdatTimeByCrlTemplateId(Long tempId) {
        try {
            Condition cnd = Cnd.wrap((String)("id=(select MAX(id) from delta_crl where crl_temp_id=" + tempId + ")"));
            DeltaCrlDO deltaCrlDO = (DeltaCrlDO)this.daoTemplate.fetch(DeltaCrlDO.class, cnd);
            if (null == deltaCrlDO) {
                return null;
            }
            return deltaCrlDO.getNextUpdateTime();
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u83b7\u53d6\u6700\u65b0DRL\u7684\u66f4\u65b0\u65f6\u95f4\u6765\u5224\u65ad\u662f\u5426\u7b7e\u53d1\u8fc7CRL\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

