/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.CrlUtil;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CrlDataDao
extends BaseJdbcDao {
    public void saveCrlDatas(Map<Integer, X509CRL> x509CRLS, Map<String, Long> map) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO crl_data (crl_id, data, gmt_create) VALUES( ").append(":crl_id, :data, :gmt_create )");
            MapSqlParameterSource[] parameterSources = new MapSqlParameterSource[x509CRLS.size()];
            int i = 0;
            for (Integer integer : x509CRLS.keySet()) {
                X509CRL x509CRL = x509CRLS.get(integer);
                MapSqlParameterSource parame = new MapSqlParameterSource();
                parame.addValue("crl_id", (Object)map.get(CrlUtil.getSnByX509Crl((X509CRL)x509CRL).toString(16)));
                parame.addValue("data", (Object)CertUtil.writeObject((Object)x509CRL));
                parame.addValue("gmt_create", (Object)new Date());
                parameterSources[i++] = parame;
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])parameterSources);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58cRL data\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveDrlDatas(Map<Integer, X509CRL> x509CRLMap, Map<String, Long> map) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO delta_crl_data (delta_crl_id, data, gmt_create) VALUES( ").append(":drl_id, :data, :gmt_create )");
            ArrayList<MapSqlParameterSource> parameterSources = new ArrayList<MapSqlParameterSource>();
            boolean i = false;
            for (Integer integer : x509CRLMap.keySet()) {
                X509CRL x509CRL = x509CRLMap.get(integer);
                MapSqlParameterSource parame = new MapSqlParameterSource();
                String key = CrlUtil.getSnByX509Crl((X509CRL)x509CRL).toString(16);
                Long value = map.get(key);
                if (null == value) continue;
                parame.addValue("drl_id", (Object)value);
                parame.addValue("data", (Object)CertUtil.writeObject((Object)x509CRL));
                parame.addValue("gmt_create", (Object)new Date());
                parameterSources.add(parame);
            }
            this.daoTemplate.batch(sqlBuffer.toString(), (SqlParameterSource[])parameterSources.toArray(new MapSqlParameterSource[parameterSources.size()]));
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58dRL data\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

