/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.PublishCertSyncDO;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PublishCertSyncDao
extends BaseJdbcDao {
    public void saveBatchPublishCert(List<PublishCertSyncDO> list) {
        try {
            this.daoTemplate.insert(list);
        }
        catch (Exception e) {
            throw new DAOException("\u6279\u91cf\u4fdd\u5b58\u5f85\u53d1\u5e03\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> queryPublishCertForList() {
        String sql = "SELECT GROUP_CONCAT(cert_id) AS certId, GROUP_CONCAT(manage_cert_id) AS manageCertId, GROUP_CONCAT(ca_cert_id) AS caCertId, GROUP_CONCAT(cross_cert_id) AS crossCertId, GROUP_CONCAT(outer_cross_cert_id) AS outCrossCertId, GROUP_CONCAT(sub_ca_id) AS subCaCertId FROM (SELECT DISTINCT cert_id, manage_cert_id, ca_cert_id, cross_cert_id, outer_cross_cert_id, sub_ca_id FROM publish_cert_sync where issue_cert_type in (1,2,3)) publish_cert";
        try {
            final HashMap<String, Object> result = new HashMap<String, Object>();
            this.daoTemplate.queryForList(sql, null, (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowId) throws SQLException {
                    do {
                        result.put("certId", rs.getString("certId"));
                        result.put("manageCertId", rs.getString("manageCertId"));
                        result.put("caCertId", rs.getString("caCertId"));
                        result.put("crossCertId", rs.getString("crossCertId"));
                        result.put("outCrossCertId", rs.getString("outCrossCertId"));
                        result.put("subCaCertId", rs.getString("subCaCertId"));
                    } while (rs.next());
                    return null;
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new DAOException("PublishCertSyncDao\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }

    public void clearPublishCert() {
        try {
            this.daoTemplate.clear(PublishCertSyncDO.class);
        }
        catch (Exception e) {
            throw new DAOException("\u6e05\u7a7a\u8bc1\u4e66\u53d1\u5e03\u540c\u6b65\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deletePublishCertSyncByCertType(String certType, List<Long> certIds) {
        String sql = "DELETE FROM publish_cert_sync WHERE " + certType + " IN (:certIds) ";
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        paramSource.addValue("certIds", certIds);
        this.logger.debug("certType\uff1a" + certType + "== certIds:" + certIds);
        try {
            int deleteBySql = this.daoTemplate.deleteBySql(sql, (SqlParameterSource)paramSource);
            this.logger.debug("publish_cert_sync\u672c\u6b21\u5220\u9664\u884c\u6570\uff1a" + deleteBySql);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u540c\u6b65\u8bc1\u4e66\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<Long> getIssueCertTypeByCertId(int certType, Long certId) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT issue_cert_type FROM publish_cert_sync WHERE 1=1 ");
            switch (certType) {
                case 1: {
                    sqlBuffer.append("and ca_cert_id = :certId ");
                    break;
                }
                case 2: {
                    sqlBuffer.append("and sub_ca_id = :certId ");
                    break;
                }
                case 3: {
                    sqlBuffer.append("and cross_cert_id = :certId ");
                    break;
                }
                case 5: {
                    sqlBuffer.append("and cert_id = :certId ");
                }
            }
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("certId", (Object)certId);
            return this.queryColumnLongForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, "issue_cert_type");
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getIssueCert(String subject) {
        try {
            String sql = "SELECT cert from ca_cert WHERE `subject` = :subject ;";
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("subject", (Object)subject);
            return this.queryColumnForList(sql, (SqlParameterSource)parameterSource, "cert");
        }
        catch (Exception e) {
            return null;
        }
    }
}

