/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.SubSystemListDO;
import com.xdja.pki.ca.certmanager.dao.models.SubSystemQueryDO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.enums.DeviceTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SubSystemDao
extends BaseJdbcDao {
    public PageInfo querySubSystemList(SubSystemQueryDO subSystemDO) {
        int status;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        int count = 0;
        int n = status = null == subSystemDO.getStatus() ? 1 : subSystemDO.getStatus();
        if (status != 4) {
            sqlBuffer.append("SELECT subServerCert.device_type deviceType,  managerCert.sn signSn, managerCert.pair_cert_sn encSn,managerCert.public_key_alg keyAlg, managerCert.before_time notBefore, managerCert.after_time notAfter, ").append("managerCert.subject certDn  ").append("FROM ca_sub_server_cert subServerCert LEFT JOIN ");
            if (status == 3) {
                sqlBuffer.append("revoked_manage_cert managerCert ");
            } else if (status == 1 || status == 2) {
                sqlBuffer.append("manage_cert managerCert ");
            } else if (status == 4) {
                sqlBuffer.append("manage_cert mc ON subServerCert.manage_cert_id = mc.id ").append("LEFT JOIN revoked_manage_cert rmc ON subServerCert.manage_cert_id = rmc.id ").append("LEFT JOIN outdate_manage_cert managerCert ");
            }
            sqlBuffer.append("ON subServerCert.manage_cert_id = managerCert.id ").append("WHERE 1=1 ");
            sqlBuffer.append("AND  managerCert.after_time > now() ");
            if (StringUtils.isNotBlank((CharSequence)subSystemDO.getCertDn())) {
                sqlBuffer.append("AND managerCert.subject LIKE :subject ");
                parameterSource.addValue("subject", (Object)("%" + subSystemDO.getCertDn() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)subSystemDO.getSn())) {
                sqlBuffer.append("AND (managerCert.sn LIKE :sn or managerCert.pair_cert_sn LIKE :sn)");
                parameterSource.addValue("sn", (Object)("%" + subSystemDO.getSn() + "%"));
            }
            if (null != subSystemDO.getDeviceType()) {
                sqlBuffer.append("AND subServerCert.device_type = :deviceType ");
                parameterSource.addValue("deviceType", (Object)subSystemDO.getDeviceType());
            }
            if ((status == 1 || status == 2) && null != subSystemDO.getStatus()) {
                sqlBuffer.append("AND managerCert.status =:status ");
                parameterSource.addValue("status", (Object)subSystemDO.getStatus());
            }
        } else {
            sqlBuffer = this.buildExpireCertSql(subSystemDO, parameterSource);
        }
        try {
            List countList = this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
            count = null == countList || countList.size() == 0 ? 0 : countList.size();
            if (status != 4) {
                sqlBuffer.append("ORDER BY managerCert.gmt_create DESC ");
            } else {
                sqlBuffer.append("ORDER BY notbefore DESC ");
            }
            sqlBuffer.append("LIMIT " + (subSystemDO.getPageNo() - 1) * subSystemDO.getPageSize() + "," + subSystemDO.getPageSize());
            PageInfo pageInfo = new PageInfo(subSystemDO.getPageNo(), subSystemDO.getPageSize(), count);
            pageInfo.setDatas((Collection)this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)new BeanPropertyRowMapper(SubSystemListDO.class)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2CA\u5b50\u7cfb\u7edf\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public StringBuffer buildExpireCertSql(SubSystemQueryDO subSystemDO, MapSqlParameterSource parameterSource) {
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer normalSqlBuffer = new StringBuffer();
        StringBuffer revokeSqlBuffer = new StringBuffer();
        StringBuffer outSqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT subServerCert.device_type deviceType,  managerCert.sn signSn, managerCert.pair_cert_sn encSn, managerCert.before_time notBefore, managerCert.after_time notAfter, ").append("managerCert.subject certDn FROM ca_sub_server_cert subServerCert JOIN ");
        normalSqlBuffer.append(sqlBuffer).append("manage_cert managerCert ON subServerCert.manage_cert_id = managerCert.id ").append("WHERE managerCert.after_time < now() ");
        revokeSqlBuffer.append(sqlBuffer).append("revoked_manage_cert managerCert ON subServerCert.manage_cert_id = managerCert.id ").append("WHERE managerCert.after_time < now() ");
        outSqlBuffer.append(sqlBuffer).append("outdate_manage_cert managerCert ON subServerCert.manage_cert_id = managerCert.id ").append("WHERE 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)subSystemDO.getCertDn())) {
            normalSqlBuffer.append("AND managerCert.subject LIKE :subject ");
            revokeSqlBuffer.append("AND managerCert.subject LIKE :subject ");
            outSqlBuffer.append("AND managerCert.subject LIKE :subject ");
            parameterSource.addValue("subject", (Object)("%" + subSystemDO.getCertDn() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)subSystemDO.getSn())) {
            normalSqlBuffer.append("AND (managerCert.sn LIKE :sn or managerCert.pair_cert_sn LIKE :sn) ");
            revokeSqlBuffer.append("AND (managerCert.sn LIKE :sn or managerCert.pair_cert_sn LIKE :sn) ");
            outSqlBuffer.append("AND (managerCert.sn LIKE :sn or managerCert.pair_cert_sn LIKE :sn)");
            parameterSource.addValue("sn", (Object)("%" + subSystemDO.getSn() + "%"));
        }
        if (null != subSystemDO.getDeviceType()) {
            normalSqlBuffer.append("AND subServerCert.device_type = :deviceType ");
            revokeSqlBuffer.append("AND subServerCert.device_type = :deviceType ");
            outSqlBuffer.append("AND subServerCert.device_type = :deviceType ");
            parameterSource.addValue("deviceType", (Object)subSystemDO.getDeviceType());
        }
        StringBuffer resultBuffer = new StringBuffer();
        resultBuffer.append("(").append(normalSqlBuffer.toString()).append(") UNION ").append(" (").append(revokeSqlBuffer.toString()).append(") UNION ").append(" (").append(outSqlBuffer.toString()).append(") ");
        return resultBuffer;
    }

    private int countSubSystemManagerExpireCert(int status) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT count(subServer.id) FROM ca_sub_server_cert subServer ").append("LEFT JOIN outdate_manage_cert manageCert ON subServer.manage_cert_id = manageCert.id ");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        return this.daoTemplate.queryForInt(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
    }

    private int countSubSystemRevokeManagerCert(int status) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT count(subServer.id) FROM ca_sub_server_cert subServer ").append("LEFT JOIN manage_cert manageCert ON subServer.manage_cert_id = manageCert.id ");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        return this.daoTemplate.queryForInt(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
    }

    public int countSubSystemManagerCert(int status) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT count(subServer.id) FROM ca_sub_server_cert subServer ").append("LEFT JOIN manage_cert manageCert ON subServer.manage_cert_id = manageCert.id ").append("WHERE manageCert.status = :status ");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("status", (Object)status);
        return this.daoTemplate.queryForInt(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Long> getCaSubSystemCertIdsByDevType(int deviceType) {
        String sql = "select manage.id from ca_sub_server_cert sub join manage_cert manage on sub.manage_cert_id=manage.id and manage.type=1 and manage.status=1 and sub.device_type=:deviceType ";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("deviceType", (Object)deviceType);
        return this.daoTemplate.queryColumnLongForList(sql, (SqlParameterSource)sqlParam, "id");
    }

    public List<String> getAllLdapServerSignCerts() {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT certData.data FROM ca_sub_server_cert subServer LEFT JOIN manage_cert_data certData ON ").append("subServer.manage_cert_id = certData.id WHERE subServer.device_type = :deviceType ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("deviceType", (Object)DeviceTypeEnum.LDAP.getValue());
            return this.daoTemplate.queryColumnForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, "certData.data");
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6240\u6709\u7684LDAP\u7b7e\u540d\u8bc1\u4e66\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

