/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao;

import com.xdja.pki.ca.certmanager.dao.models.ExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateCodeDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateExtensionDO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateListDTO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateDao
extends BaseJdbcDao {
    public PageInfo queryTemplates(TemplateDO query, int pageNo, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT t.`id` AS id, t.`code` AS code,t.`ca_id` AS caId, t.`name` AS name, t.`type` AS type , t.`cert_patterm` AS certPatterm, t.`sign_alg` AS signAlg,t.`status` AS status,b.`id` AS crlTempId, b.`crl_temp_name` AS crlTempName");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM (SELECT a.`id`, a.`code`, a.`name`, a.`ca_id`, a.`type`  , a.`cert_patterm` , a.`sign_alg`,a.`status` ,a.`crl_temp_id` ,a.`gmt_create`FROM template a WHERE  a.`is_inner` = " + TemplateDO.InnerTypeEnum.NO.getValue());
        if (StringUtils.isNotBlank((CharSequence)query.getName())) {
            fromSql.append(" AND a.`name` LIKE :tempName ");
            params.addValue("tempName", (Object)("%" + query.getName() + "%"));
        }
        if (null != query.getType()) {
            fromSql.append(" AND a.type = :tempType");
            params.addValue("tempType", (Object)query.getType());
        }
        if (null != query.getStatus()) {
            fromSql.append(" AND a.status = :tempStatus");
            params.addValue("tempStatus", (Object)query.getStatus());
        }
        if (null != query.getCrlTempId()) {
            fromSql.append(" AND a.crl_temp_id = :crlTempId");
            params.addValue("crlTempId", (Object)query.getCrlTempId());
        }
        if (null != query.getOpenCrl()) {
            fromSql.append(" AND a.open_crl = :openCrl");
            params.addValue("openCrl", (Object)(query.getOpenCrl() != false ? 1 : 0));
        }
        if (null != query.getCaId()) {
            fromSql.append(" AND a.ca_id = :caId");
            params.addValue("caId", (Object)query.getCaId());
        }
        fromSql.append(" ) t LEFT JOIN crl_template b ON t.crl_temp_id = b.id  ");
        StringBuilder orderSql = new StringBuilder();
        orderSql.append(" ORDER BY t.gmt_create DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.queryForInt(countSql.toString(), (SqlParameterSource)params));
        selectSql.append((CharSequence)fromSql.append((CharSequence)orderSql));
        selectSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)pageInfo.getOffset());
        params.addValue("pageSize", (Object)pageInfo.getPageSize());
        pageInfo.setDatas((Collection)this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(TemplateListDTO.class)));
        return pageInfo;
    }

    public TemplateDO getTemplateByType(int type, int keyAlg) {
        Cnd cnd = Cnd.where((String)"isInner", (String)"=", (Object)TemplateDO.InnerTypeEnum.YES.getValue());
        cnd.and("keyAlg", "=", (Object)keyAlg);
        cnd.and("type", "=", (Object)type);
        try {
            return (TemplateDO)this.daoTemplate.fetch(TemplateDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u5185\u7f6e\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Map<ExtensionDO, TemplateExtensionDO>> getExtensionsByCodes(int isInner, String ... codes) {
        final HashMap<String, Map<ExtensionDO, TemplateExtensionDO>> result = new HashMap<String, Map<ExtensionDO, TemplateExtensionDO>>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT template.code, ext.name, ext.extn_id, ext.is_input, te.is_critical, te.value");
        sql.append(" FROM template template");
        sql.append(" JOIN template_extension te ON te.template_id = template.id");
        sql.append(" JOIN extension ext ON ext.id = te.extension_id WHERE template.is_inner = :isInner ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("isInner", (Object)isInner);
        if (1 == Arrays.asList(codes).size()) {
            sql.append(" AND template.code = :codes ");
            params.addValue("codes", (Object)Arrays.asList(codes).get(0));
        } else {
            sql.append(" AND template.code IN (:codes)");
            params.addValue("codes", Arrays.asList(codes));
        }
        try {
            this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<ExtensionDO, TemplateExtensionDO> extensions = null;
                    TemplateExtensionDO templateExtension = null;
                    ExtensionDO extension = null;
                    String code = null;
                    do {
                        if (null == (extensions = (HashMap<ExtensionDO, TemplateExtensionDO>)result.get(code = rs.getString("code")))) {
                            extensions = new HashMap<ExtensionDO, TemplateExtensionDO>();
                            result.put(code, extensions);
                        }
                        extension = new ExtensionDO();
                        extension.setExtnId(rs.getString("extn_id"));
                        extension.setName(rs.getString("name"));
                        extension.setIsInput(rs.getInt("is_input"));
                        templateExtension = new TemplateExtensionDO();
                        templateExtension.setIsCritical(rs.getInt("is_critical"));
                        templateExtension.setValue(rs.getString("value"));
                        extensions.put(extension, templateExtension);
                    } while (rs.next());
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u6279\u91cf\u83b7\u53d6\u5bf9\u5e94\u6269\u5c55\u9879\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public List<TemplateDO> getTemplatesByCodes(String ... codes) {
        return this.getTemplatesByCodes(false, codes);
    }

    public TemplateDO getTemplatesById(Long id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        try {
            return (TemplateDO)this.daoTemplate.fetch(TemplateDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677fID\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<TemplateDO> getTemplatesByCodes(boolean isInner, String ... codes) {
        Cnd cnd = Cnd.where((String)"isInner", (String)"=", (Object)(isInner ? TemplateDO.InnerTypeEnum.YES.getValue() : TemplateDO.InnerTypeEnum.NO.getValue()));
        if (1 == Arrays.asList(codes).size()) {
            cnd.and("code", "=", (Object)Arrays.asList(codes).get(0));
        } else {
            cnd.and("code", "IN", (Object)codes);
        }
        try {
            return this.daoTemplate.query(TemplateDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u6279\u91cf\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<TemplateDO> getTemplatesByType(int type, Long caId) {
        Cnd cnd = Cnd.where((String)"isInner", (String)"=", (Object)TemplateDO.InnerTypeEnum.NO.getValue());
        if (null != caId) {
            cnd.and("ca_id", "=", (Object)caId);
        }
        cnd.and("type", "=", (Object)type);
        cnd.and("status", "=", (Object)TemplateStatusEnum.NORMAL.getValue());
        try {
            return this.daoTemplate.query(TemplateDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateTemplate(TemplateDO template) {
        try {
            this.daoTemplate.updateIgnoreNull((Object)template);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteTemplate(long id) {
        try {
            this.daoTemplate.delete(TemplateDO.class, id);
            MapSqlParameterSource params = new MapSqlParameterSource("templateId", (Object)id);
            this.daoTemplate.deleteBySql("DELETE FROM template_extension WHERE template_id = :templateId", (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public long incrTemplateCode() {
        try {
            TemplateCodeDO templateCode = new TemplateCodeDO();
            templateCode.setGmtCreate(new Date());
            this.daoTemplate.insert((Object)templateCode);
            return templateCode.getId();
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u6700\u65b0\u6a21\u677f\u7f16\u53f7\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public TemplateDO getTemplateById(Long id) {
        try {
            return (TemplateDO)this.daoTemplate.fetch(TemplateDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Long> getExtensionIdByOID(List<String> oids) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            List extensions = this.daoTemplate.query(ExtensionDO.class, (Condition)Cnd.where((String)"extnId", (String)"IN", oids));
            for (ExtensionDO item : extensions) {
                result.put(item.getExtnId(), item.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eOID\u5217\u8868\u83b7\u53d6\u6570\u636e\u5e93ID\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public TemplateDO saveTemplate(TemplateDO template) {
        try {
            TemplateDO templateDO = (TemplateDO)this.daoTemplate.insert((Object)template);
            return templateDO;
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u6a21\u677f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveTemplateExtensions(List<TemplateExtensionDO> list) {
        try {
            this.daoTemplate.insert(list);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u6a21\u677f\u6269\u5c55\u9879\u5173\u7cfb\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteTemplateExtensionByTemplateId(long templateId) {
        try {
            String sql = "DELETE FROM template_extension WHERE template_id = :templateId";
            this.daoTemplate.deleteBySql(sql, (SqlParameterSource)new MapSqlParameterSource("templateId", (Object)templateId));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u6a21\u677fId\u5220\u9664\u6a21\u677f\u6269\u5c55\u9879\u5173\u7cfb\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public boolean checkTemplateNameExist(String name) {
        Cnd cnd = Cnd.where((String)"name", (String)"=", (Object)name).and("isInner", "=", (Object)TemplateDO.InnerTypeEnum.NO.getValue());
        return this.daoTemplate.count(TemplateDO.class, (Condition)cnd) > 0;
    }

    public List<Long> getOpenCrlTemplateId() {
        try {
            String sql = "SELECT id  FROM template WHERE is_inner = 1 AND open_crl = 1";
            return this.daoTemplate.queryColumnLongForList(sql, null, "id");
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int updateLinkCrlTemplate(long certTempId, long crlTempId) {
        try {
            MapSqlParameterSource paramSource = new MapSqlParameterSource();
            paramSource.addValue("crlTempId", (Object)crlTempId);
            paramSource.addValue("certTempId", (Object)certTempId);
            String sql = "update template set crl_temp_id = :crlTempId where id= :certTempId ";
            int update = this.daoTemplate.update(sql, (SqlParameterSource)paramSource);
            return update;
        }
        catch (Exception e) {
            throw new DAOException("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u5f02\u5e38", (Throwable)e);
        }
    }

    public long getCrlTempIdByCertTempId(long certTempId) {
        try {
            MapSqlParameterSource paramSource = new MapSqlParameterSource();
            paramSource.addValue("certTempId", (Object)certTempId);
            String sql = "select crl_temp_id from template where id= :certTempId ";
            long id = this.daoTemplate.queryForInt(sql, (SqlParameterSource)paramSource);
            return id;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u8bc1\u4e66\u6a21\u677f\u7f16\u53f7\u83b7\u53d6CRL\u6a21\u677f\u7f16\u53f7\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<Long> getAllTemplateIdByCrlTemplateId(Long crlId) {
        try {
            String sql = "select id from template where crl_temp_id=:crlId";
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("crlId", (Object)crlId);
            return this.daoTemplate.queryColumnLongForList(sql, (SqlParameterSource)parameterSource, "id");
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7crl_id\u83b7\u53d6template_id\u5f02\u5e38", (Throwable)e);
        }
    }

    public Long getTemplateCertCount(List<Long> templateIds) {
        try {
            String sql = "select sum(a) from (select count(0) a from cert where template_id in ( :templateIds) union all select count(0) a from revoked_cert where template_id in ( :templateIds) union select count(0) a from outdate_cert where template_id in ( :templateIds) union select count(0) a from archive_cert where template_id in ( :templateIds) ) b ";
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("templateIds", templateIds);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u6a21\u677fid\u83b7\u53d6\u8be5\u6a21\u677f\u8bc1\u4e66\u6570\u91cf\u5f02\u5e38", (Throwable)e);
        }
    }
}

